/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.util;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lnl/stokpop/memory/util/ConversionUtils;", "", "()V", "convertHumanReadableToBytes", "", "input", "", "humanReadableMemorySize", "v", "NumberConversionException", "memory-check"})
public final class ConversionUtils {
    @NotNull
    public static final ConversionUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final long convertHumanReadableToBytes(@NotNull String input) {
        long l;
        String string;
        int n;
        CharSequence $this$takeWhile$iv;
        String numbers;
        int n2;
        String trimmed;
        block37: {
            String string2;
            int n3;
            int index$iv;
            int it22;
            block36: {
                void $this$takeWhile$iv2;
                String string3;
                int index$iv2;
                block35: {
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    String string4 = input;
                    boolean bl = false;
                    String $this$takeWhile$iv3 = trimmed = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                    boolean $i$f$takeWhile = false;
                    int n4 = 0;
                    n2 = $this$takeWhile$iv3.length();
                    while (n4 < n2) {
                        char it22 = $this$takeWhile$iv3.charAt(index$iv2);
                        int n5 = 0;
                        if (!(Character.isDigit(it22) || it22 == '.')) {
                            String it22 = $this$takeWhile$iv3;
                            n5 = 0;
                            boolean bl2 = false;
                            String string5 = it22.substring(n5, index$iv2);
                            string3 = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            break block35;
                        }
                        ++index$iv2;
                    }
                    string3 = $this$takeWhile$iv3;
                }
                numbers = string3;
                String $i$f$takeWhile = trimmed;
                index$iv2 = numbers.length();
                n2 = 0;
                String string6 = $i$f$takeWhile;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(index$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                $i$f$takeWhile = string7;
                boolean $i$f$takeWhile2 = false;
                n2 = 0;
                it22 = $this$takeWhile$iv2.length();
                while (n2 < it22) {
                    char it3 = $this$takeWhile$iv2.charAt(index$iv);
                    int n6 = 0;
                    if (!Character.isSpaceChar(it3)) {
                        void var9_17 = $this$takeWhile$iv2;
                        n6 = 0;
                        n3 = 0;
                        String string8 = var9_17.substring(n6, index$iv);
                        string2 = string8;
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block36;
                    }
                    ++index$iv;
                }
                string2 = $this$takeWhile$iv2;
            }
            void whitespace = string2;
            String $i$f$takeWhile2 = trimmed;
            index$iv = numbers.length() + whitespace.length();
            it22 = 0;
            String string9 = $i$f$takeWhile2;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(index$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            $i$f$takeWhile2 = string10;
            boolean $i$f$takeWhile = false;
            it22 = 0;
            n = ((String)$this$takeWhile$iv).length();
            while (it22 < n) {
                void index$iv3;
                char it4 = ((String)$this$takeWhile$iv).charAt((int)index$iv3);
                boolean bl = false;
                if (!Character.isLetter(it4)) {
                    void var10_20 = $this$takeWhile$iv;
                    n3 = 0;
                    boolean bl3 = false;
                    String string11 = var10_20.substring(n3, (int)index$iv3);
                    string = string11;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block37;
                }
                ++index$iv3;
            }
            string = $this$takeWhile$iv;
        }
        $this$takeWhile$iv = string;
        n2 = 0;
        void v10 = $this$takeWhile$iv;
        if (v10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string12 = v10.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).toLowerCase()");
        String letters = string12;
        $this$takeWhile$iv = numbers;
        n2 = 0;
        if ($this$takeWhile$iv.length() == 0) {
            throw (Throwable)new NumberConversionException("No numbers found in '" + trimmed + '\'');
        }
        String string13 = numbers;
        n = 0;
        double value = Double.parseDouble(string13);
        switch (letters) {
            case "": 
            case "b": {
                l = (long)value;
                break;
            }
            case "k": 
            case "kb": {
                l = (long)(value * (double)1024L);
                break;
            }
            case "m": 
            case "mb": {
                l = (long)(value * (double)0x100000L);
                break;
            }
            case "g": 
            case "gb": {
                l = (long)(value * (double)0x40000000L);
                break;
            }
            case "tb": 
            case "t": {
                l = (long)(value * (double)0x10000000000L);
                break;
            }
            case "p": 
            case "pb": {
                l = (long)(value * (double)0x4000000000000L);
                break;
            }
            case "e": 
            case "eb": {
                l = (long)(value * (double)0x1000000000000000L);
                break;
            }
            default: {
                throw (Throwable)new NumberConversionException("Unknown letters to convert to bytes: " + letters + " (from '" + trimmed + "')");
            }
        }
        return l;
    }

    @NotNull
    public final String humanReadableMemorySize(long v) {
        if (v < (long)1024) {
            return v + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ENGLISH;
        String string = "%.1f %sB";
        Object[] objectArray = new Object[]{(double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z))};
        boolean bl = false;
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        return string2;
    }

    private ConversionUtils() {
    }

    static {
        ConversionUtils conversionUtils;
        INSTANCE = conversionUtils = new ConversionUtils();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnl/stokpop/memory/util/ConversionUtils$NumberConversionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "memory-check"})
    public static final class NumberConversionException
    extends Exception {
        public NumberConversionException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }
}

