/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo.targetsio;

import io.gatling.mojo.targetsio.log.Logger;
import io.gatling.mojo.targetsio.log.SystemOutLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class HttpClient {
    final int MAX_RETRIES = 10;
    final long SLEEP_IN_MILLIS = 30000L;
    static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    final OkHttpClient client = new OkHttpClient();
    Logger logger = new SystemOutLogger();
    private Map<String, String> headers;

    HttpClient() {
        this(Collections.emptyMap());
    }

    HttpClient(Map<String, String> headers) {
        this.headers = headers;
    }

    public void injectLogger(Logger logger) {
        this.logger = logger;
    }

    String getReplyForRequestWithRetries(Request request, int maxRetries, long sleepInMillis) throws MojoExecutionException {
        String replyBody = null;
        int retries = 0;
        while (retries <= maxRetries) {
            try (Response response = this.client.newCall(request).execute();){
                ResponseBody responseBody = response.body();
                if (HttpClient.isHttpSuccessCode(response.code())) {
                    replyBody = responseBody == null ? "null" : responseBody.string();
                    break;
                }
                String message = responseBody == null ? response.message() : responseBody.string();
                this.logger.warn("Failed to call url [" + request.url() + "] code [" + response.code() + "] retry [" + retries + "/" + maxRetries + "] " + message);
                try {
                    Thread.sleep(sleepInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                this.logger.warn("An exception happened trying to retrieve url [" + request.url() + "]: " + e.getMessage());
            }
            if (++retries != maxRetries) continue;
            throw new MojoExecutionException("Max retries reached: unable to retrieve url [" + request.url() + "]");
        }
        return replyBody;
    }

    private static boolean isHttpSuccessCode(int code) {
        return code >= 200 && code < 300;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static Map<String, String> parseHeaders(String headers) {
        if (headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(Arrays.stream(headers.split(",")).map(pair -> pair.split(":")).collect(Collectors.toMap(nameValue -> nameValue[0], nameValue -> nameValue[1])));
    }
}

