/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo.targetsio;

import io.gatling.mojo.targetsio.HttpClient;
import io.gatling.mojo.targetsio.log.Logger;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;

public class TargetsIoClient
extends HttpClient {
    private final String productName;
    private final String dashboardName;
    private final String testRunId;
    private final String buildResultsUrl;
    private final String productRelease;
    private final String targetsIoUrl;
    private final String rampupTimeSeconds;

    public TargetsIoClient(String productName, String dashboardName, String testRunId, String buildResultsUrl, String productRelease, String rampupTimeInSeconds, String targetsIoUrl) {
        this.productName = productName;
        this.dashboardName = dashboardName;
        this.testRunId = testRunId;
        this.buildResultsUrl = buildResultsUrl;
        this.productRelease = productRelease;
        this.rampupTimeSeconds = rampupTimeInSeconds;
        this.targetsIoUrl = targetsIoUrl;
    }

    @Override
    public void injectLogger(Logger logger) {
        this.logger = logger;
    }

    public void callTargetsIoFor(Action action) {
        String json = this.targetsIoJson(this.productName, this.dashboardName, this.testRunId, this.buildResultsUrl, this.productRelease, this.rampupTimeSeconds);
        this.logger.debug(String.join((CharSequence)" ", "Call for", action.getName(), "endpoint:", this.targetsIoUrl, "with json:", json));
        try {
            String result = this.post(this.targetsIoUrl + "/running-test/" + action.getName(), json);
            this.logger.debug("Result: " + result);
        }
        catch (IOException e) {
            this.logger.error("Failed to call keep-alive url: " + e.getMessage());
        }
    }

    private String post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody responseBody = response.body();
            String string = responseBody == null ? "null" : responseBody.string();
            return string;
        }
    }

    private String targetsIoJson(String productName, String dashboardName, String testRunId, String buildResultsUrl, String productRelease, String rampupTimeSeconds) {
        return String.join((CharSequence)"", "{'testRunId':'", testRunId, "','dashboardName':'", dashboardName, "','productName':'", productName, "','productRelease':'", productRelease, "','buildResultsUrl':'", buildResultsUrl, "','rampUpPeriod':", rampupTimeSeconds, "}").replace("'", "\"");
    }

    public String callCheckAsserts() throws MojoExecutionException {
        String url = String.join((CharSequence)"/", this.targetsIoUrl, "benchmarks", this.productName, this.dashboardName, this.testRunId);
        Request request = new Request.Builder().url(url).get().build();
        return this.getReplyForRequestWithRetries(request, 10, 30000L);
    }

    public static class KeepAliveRunner
    implements Runnable {
        private final TargetsIoClient client;

        public KeepAliveRunner(TargetsIoClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            this.client.callTargetsIoFor(Action.KeepAlive);
        }
    }

    public static enum Action {
        KeepAlive("keep-alive"),
        End("end");

        private String name;

        private Action(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

