/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo.targetsio;

import io.gatling.mojo.targetsio.TestRunClock;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;

public class UrlToRemoteSystem {
    private static final Pattern PLACEHOLDER_TEST_START_TIME = Pattern.compile("\\{\\{testStartTime}}");
    private static final Pattern PLACEHOLDER_TEST_END_TIME = Pattern.compile("\\{\\{testEndTime}}");
    private String urlToRemoteSystem;

    public UrlToRemoteSystem(String urlWithPlaceHolders, TestRunClock testRunClock) throws MojoExecutionException {
        if (urlWithPlaceHolders == null) {
            throw new MojoExecutionException(String.format("The remote system url is null.", new Object[0]));
        }
        if (!PLACEHOLDER_TEST_START_TIME.matcher(urlWithPlaceHolders).find()) {
            throw new MojoExecutionException(String.format("Placeholder [%s] for test start time in missing in remote system url [%s]", PLACEHOLDER_TEST_START_TIME, urlWithPlaceHolders));
        }
        if (!PLACEHOLDER_TEST_END_TIME.matcher(urlWithPlaceHolders).find()) {
            throw new MojoExecutionException(String.format("Placeholder [%s] for test start time in missing in remote system url [%s]", PLACEHOLDER_TEST_END_TIME, urlWithPlaceHolders));
        }
        String testStartTime = String.valueOf(testRunClock.getTestStartTime());
        String testEndTime = String.valueOf(testRunClock.getTestEndTime());
        this.urlToRemoteSystem = PLACEHOLDER_TEST_END_TIME.matcher(PLACEHOLDER_TEST_START_TIME.matcher(urlWithPlaceHolders).replaceAll(testStartTime)).replaceAll(testEndTime);
    }

    public String urlBasedOnTestRunClock() {
        return this.urlToRemoteSystem;
    }

    public String toString() {
        return "UrlToRemoteSystem{urlToRemoteSystem='" + this.urlToRemoteSystem + '\'' + '}';
    }
}

