/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.helloworld.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.TestContext;

public class StokpopHelloEvent
extends EventAdapter {
    private static final int TO_MB = 0x100000;

    public StokpopHelloEvent(String eventName, TestContext testContext, EventProperties eventProperties, EventLogger logger) {
        super(eventName, testContext, eventProperties, logger);
        logger.info("Default constructor called.");
        this.printSystemInfo();
    }

    private void printSystemInfo() {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        long totalMemoryBytes = Runtime.getRuntime().totalMemory();
        long freeMemoryBytes = Runtime.getRuntime().freeMemory();
        this.logger.info(String.format("Number of processors: %-6d cores", processors));
        this.logger.info(String.format("Max memory:           %-6d MB", maxMemoryBytes / 0x100000L));
        this.logger.info(String.format("Total memory:         %-6d MB", totalMemoryBytes / 0x100000L));
        this.logger.info(String.format("Free memory:          %-6d MB", freeMemoryBytes / 0x100000L));
    }

    public void beforeTest() {
        this.logger.info("Hello before test [" + this.testContext.getTestRunId() + "]");
        this.logger.info("Event properties: " + this.eventProperties);
        try {
            this.logger.info("Sleep for 2 seconds");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.logger.info("Thread sleep interrupted");
            Thread.currentThread().interrupt();
        }
        this.logger.info("Wakeup after 2 seconds");
    }

    public void afterTest() {
        this.logger.info("Hello after test [" + this.testContext.getTestRunId() + "]");
    }

    public void keepAlive() {
        this.logger.info("Hello keep alive for test [" + this.testContext.getTestRunId() + "]");
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        if ("fail-over".equalsIgnoreCase(eventName)) {
            this.failOverEvent(scheduleEvent);
        } else if ("scale-down".equalsIgnoreCase(eventName)) {
            this.scaleDownEvent(scheduleEvent);
        } else if ("heapdump".equalsIgnoreCase(eventName)) {
            this.heapdumpEvent(scheduleEvent);
        } else if ("restart".equalsIgnoreCase(eventName)) {
            this.restart(scheduleEvent);
        } else {
            this.logger.info("WARNING: ignoring unknown event [" + eventName + "]");
        }
    }

    private void restart(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "10000"));
        this.logger.info("Start " + scheduleEvent);
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            this.logger.info("WARNING: Restart thread was interrupted!");
            Thread.currentThread().interrupt();
        }
        this.logger.info("Finish " + scheduleEvent);
    }

    private void heapdumpEvent(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "4000"));
        this.logger.info("Start " + scheduleEvent);
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            this.logger.info("WARNING: Heap dump thread was interrupted!");
            Thread.currentThread().interrupt();
        }
        this.logger.info("Finish " + scheduleEvent);
    }

    private void scaleDownEvent(CustomEvent scheduleEvent) {
        this.logger.info("dispatched scale-down event for test [" + this.testContext.getTestRunId() + "] with settings [" + scheduleEvent.getSettings() + "]");
    }

    private void failOverEvent(CustomEvent scheduleEvent) {
        Map<String, String> parsedSettings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        this.logger.info("dispatched fail-over event for test [" + this.testContext.getTestRunId() + "] with parsed settings: " + parsedSettings);
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    private static void sayStatic(String something) {
        System.out.printf("[%s] %s%n", StokpopHelloEvent.class.getSimpleName(), something);
    }

    static {
        StokpopHelloEvent.sayStatic("Class loaded");
    }
}

