/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.helloworld.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.TestContext;

public class StokpopHelloEvent
extends EventAdapter {
    private static final int TO_MB = 0x100000;
    private Set<String> allowedProperties = StokpopHelloEvent.setOf((String[])((String[])AllowedProperties.stream().map(AllowedProperties::getPropertyName).toArray(String[]::new)));
    private Set<String> allowedCustomEvents = StokpopHelloEvent.setOf((String[])((String[])AllowedCustomEvents.stream().map(AllowedCustomEvents::getEventName).toArray(String[]::new)));

    public StokpopHelloEvent(String eventName, TestContext testContext, EventProperties eventProperties, EventLogger logger) {
        super(eventName, testContext, eventProperties, logger);
        logger.info("Default constructor called.");
        this.printSystemInfo();
        String helloMessage = eventProperties.getPropertyOrDefault(AllowedProperties.helloMessage.getPropertyName(), "Default Hello Message");
        logger.info("Message: " + helloMessage);
    }

    public Collection<String> allowedProperties() {
        return this.allowedProperties;
    }

    public Collection<String> allowedCustomEvents() {
        return this.allowedCustomEvents;
    }

    private void printSystemInfo() {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        long totalMemoryBytes = Runtime.getRuntime().totalMemory();
        long freeMemoryBytes = Runtime.getRuntime().freeMemory();
        this.logger.info(String.format("Number of processors: %-6d cores", processors));
        this.logger.info(String.format("Max memory:           %-6d MB", maxMemoryBytes / 0x100000L));
        this.logger.info(String.format("Total memory:         %-6d MB", totalMemoryBytes / 0x100000L));
        this.logger.info(String.format("Free memory:          %-6d MB", freeMemoryBytes / 0x100000L));
    }

    public void beforeTest() {
        this.logger.info("Hello before test [" + this.testContext.getTestRunId() + "]");
        this.logger.info("Event properties: " + this.eventProperties);
        String helloInitialSleepSeconds = this.eventProperties.getPropertyOrDefault(AllowedProperties.initialSleepSeconds.getPropertyName(), "2");
        int sleepSeconds = Integer.parseInt(helloInitialSleepSeconds);
        try {
            this.logger.info("Sleep for " + sleepSeconds + " seconds");
            Thread.sleep(sleepSeconds * 1000);
        }
        catch (InterruptedException e) {
            this.logger.info("Thread sleep interrupted");
            Thread.currentThread().interrupt();
        }
        this.logger.info("Wakeup after " + sleepSeconds + " seconds");
    }

    public void afterTest() {
        this.logger.info("Hello after test [" + this.testContext.getTestRunId() + "]");
    }

    public void keepAlive() {
        this.logger.info("Hello keep alive for test [" + this.testContext.getTestRunId() + "]");
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        if (AllowedCustomEvents.failOver.hasEventName(eventName)) {
            this.failOverEvent(scheduleEvent);
        } else if (AllowedCustomEvents.scaleDown.hasEventName(eventName)) {
            this.scaleDownEvent(scheduleEvent);
        } else if (AllowedCustomEvents.heapdump.hasEventName(eventName)) {
            this.heapdumpEvent(scheduleEvent);
        } else if (AllowedCustomEvents.restart.hasEventName(eventName)) {
            this.restart(scheduleEvent);
        } else {
            this.logger.info("WARNING: ignoring unknown event [" + eventName + "]");
        }
    }

    private void restart(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "10000"));
        this.logger.info("Start " + scheduleEvent);
        this.sleep(durationInMillis);
        this.logger.info("Finish " + scheduleEvent);
    }

    private void heapdumpEvent(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "4000"));
        this.logger.info("Start " + scheduleEvent);
        this.sleep(durationInMillis);
        this.logger.info("Finish " + scheduleEvent);
    }

    private void sleep(int durationInMillis) {
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            this.logger.info("WARNING: Heap dump thread was interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    private void scaleDownEvent(CustomEvent scheduleEvent) {
        this.logger.info("dispatched scale-down event for test [" + this.testContext.getTestRunId() + "] with settings [" + scheduleEvent.getSettings() + "]");
    }

    private void failOverEvent(CustomEvent scheduleEvent) {
        Map<String, String> parsedSettings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        this.logger.info("dispatched fail-over event for test [" + this.testContext.getTestRunId() + "] with parsed settings: " + parsedSettings);
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    private static void sayStatic(String something) {
        System.out.printf("[%s] %s%n", StokpopHelloEvent.class.getSimpleName(), something);
    }

    static {
        StokpopHelloEvent.sayStatic("Class loaded");
    }

    static enum AllowedCustomEvents {
        failOver("fail-over"),
        scaleDown("scale-down"),
        heapdump("heapdump"),
        restart("restart");

        private String eventName;

        private AllowedCustomEvents(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static Stream<AllowedCustomEvents> stream() {
            return Stream.of(AllowedCustomEvents.values());
        }

        public boolean hasEventName(String name) {
            return this.eventName.equals(name);
        }
    }

    static enum AllowedProperties {
        initialSleepSeconds("helloInitialSleepSeconds"),
        helloMessage("helloMessage"),
        myRestServer("myRestServer");

        private String propertyName;

        private AllowedProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public static Stream<AllowedProperties> stream() {
            return Stream.of(AllowedProperties.values());
        }
    }
}

