/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.actuator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import nl.stokpop.actuator.ActuatorEnvs;
import nl.stokpop.actuator.Value;
import nl.stokpop.actuator.Variable;

public class ActuatorClient {
    private final String baseUrl;
    private final Gson gson = new GsonBuilder().create();
    private HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(2L)).build();

    public ActuatorClient(String actuatorUrl) {
        this.baseUrl = actuatorUrl;
    }

    public List<Variable> queryActuator(List<String> envKeys) {
        String totalUrl = this.baseUrl + "/env";
        try {
            URI envUri = new URI(totalUrl);
            HttpRequest httpRequest = HttpRequest.newBuilder(envUri).timeout(Duration.ofSeconds(2L)).build();
            HttpResponse<String> response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Unexpected status code (not 200): " + response.statusCode() + " for " + httpRequest.uri());
            }
            String body = response.body();
            ActuatorEnvs envs = (ActuatorEnvs)this.gson.fromJson(body, ActuatorEnvs.class);
            return envs.propertySources.stream().flatMap(it -> it.properties.entrySet().stream()).filter(it -> envKeys.contains(it.getKey())).map(it -> new Variable((String)it.getKey(), ((Value)it.getValue()).value)).collect(Collectors.toList());
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException("Cannot get " + totalUrl, e);
        }
    }
}

