/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.helloworld.event;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.stokpop.actuator.ActuatorClient;
import nl.stokpop.actuator.Variable;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.message.EventMessage;
import nl.stokpop.eventscheduler.api.message.EventMessageBus;
import nl.stokpop.helloworld.event.StokpopHelloEventContext;

public class StokpopHelloEvent
extends EventAdapter<StokpopHelloEventContext> {
    private static final int TO_MB = 0x100000;
    private final Set<String> allowedCustomEvents = StokpopHelloEvent.setOf((String[])((String[])AllowedCustomEvents.stream().map(AllowedCustomEvents::getEventName).toArray(String[]::new)));

    public StokpopHelloEvent(StokpopHelloEventContext eventContext, EventMessageBus messageBus, EventLogger logger) {
        super((EventContext)eventContext, messageBus, logger);
        logger.info("Default constructor called.");
        this.printSystemInfo();
        String helloMessage = eventContext.getHelloMessage();
        logger.info("Message: " + helloMessage);
        logger.info("Got StokpopHelloEventConfig: " + eventContext);
        this.eventMessageBus.addReceiver(m -> logger.info("Received message: " + m));
    }

    private void printSystemInfo() {
        int processors = Runtime.getRuntime().availableProcessors();
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        long totalMemoryBytes = Runtime.getRuntime().totalMemory();
        long freeMemoryBytes = Runtime.getRuntime().freeMemory();
        this.logger.info(String.format("Number of processors: %-6d cores", processors));
        this.logger.info(String.format("Max memory:           %-6d MB", maxMemoryBytes / 0x100000L));
        this.logger.info(String.format("Total memory:         %-6d MB", totalMemoryBytes / 0x100000L));
        this.logger.info(String.format("Free memory:          %-6d MB", freeMemoryBytes / 0x100000L));
    }

    public Collection<String> allowedCustomEvents() {
        return this.allowedCustomEvents;
    }

    public void beforeTest() {
        this.logger.info("Hello before test [" + ((StokpopHelloEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
        String pluginName = StokpopHelloEvent.class.getSimpleName() + "-" + ((StokpopHelloEventContext)this.eventContext).getName();
        String actuatorBaseUrl = ((StokpopHelloEventContext)this.eventContext).getActuatorBaseUrl();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (actuatorBaseUrl != null) {
            ActuatorClient actuatorClient = new ActuatorClient(actuatorBaseUrl);
            variables.addAll(actuatorClient.queryActuator(((StokpopHelloEventContext)this.eventContext).getActuatorEnvProperties()));
        }
        EventMessage.EventMessageBuilder builder = EventMessage.builder();
        builder.pluginName(pluginName).message("Hello there!").variable("perfana-hello-world-message", "Hello World!").variable("perfana-hello-world-magic-number", "42");
        String actuatorPropPrefix = ((StokpopHelloEventContext)this.eventContext).getActuatorPropPrefix();
        variables.forEach(v -> builder.variable(actuatorPropPrefix + "-" + v.getName(), v.getValue()));
        EventMessage message = builder.build();
        this.eventMessageBus.send(message);
        Duration helloInitialSleep = ((StokpopHelloEventContext)this.eventContext).getHelloInitialSleep();
        Duration sleep = helloInitialSleep == null ? Duration.ofSeconds(2L) : helloInitialSleep;
        try {
            this.logger.info("Sleep for " + sleep);
            Thread.sleep(sleep.toMillis());
        }
        catch (InterruptedException e) {
            this.logger.info("Thread sleep interrupted");
            Thread.currentThread().interrupt();
        }
        this.logger.info("Wakeup after " + sleep + " now send Go! message!");
        this.eventMessageBus.send(EventMessage.builder().pluginName(pluginName).message("Go!").build());
    }

    public void afterTest() {
        this.logger.info("Hello after test [" + ((StokpopHelloEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
    }

    public void keepAlive() {
        this.logger.info("Hello keep alive for test [" + ((StokpopHelloEventContext)this.eventContext).getTestContext().getTestRunId() + "]");
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        if (AllowedCustomEvents.failOver.hasEventName(eventName)) {
            this.failOverEvent(scheduleEvent);
        } else if (AllowedCustomEvents.scaleDown.hasEventName(eventName)) {
            this.scaleDownEvent(scheduleEvent);
        } else if (AllowedCustomEvents.heapdump.hasEventName(eventName)) {
            this.heapdumpEvent(scheduleEvent);
        } else if (AllowedCustomEvents.restart.hasEventName(eventName)) {
            this.restart(scheduleEvent);
        } else if (AllowedCustomEvents.helloWorld.hasEventName(eventName)) {
            this.logger.info("Custom hello world called:" + scheduleEvent.getSettings());
        } else {
            this.logger.info("WARNING: ignoring unknown event [" + eventName + "]");
        }
    }

    private void restart(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "10000"));
        this.logger.info("Start " + scheduleEvent);
        this.sleep(durationInMillis);
        this.logger.info("Finish " + scheduleEvent);
    }

    private void heapdumpEvent(CustomEvent scheduleEvent) {
        Map<String, String> settings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        int durationInMillis = Integer.parseInt(settings.getOrDefault("durationInMillis", "4000"));
        this.logger.info("Start " + scheduleEvent);
        this.sleep(durationInMillis);
        this.logger.info("Finish " + scheduleEvent);
    }

    private void sleep(int durationInMillis) {
        try {
            Thread.sleep(durationInMillis);
        }
        catch (InterruptedException e) {
            this.logger.info("WARNING: Heap dump thread was interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    private void scaleDownEvent(CustomEvent scheduleEvent) {
        this.logger.info("dispatched scale-down event for test [" + ((StokpopHelloEventContext)this.eventContext).getTestContext().getTestRunId() + "] with settings [" + scheduleEvent.getSettings() + "]");
    }

    private void failOverEvent(CustomEvent scheduleEvent) {
        Map<String, String> parsedSettings = StokpopHelloEvent.parseSettings(scheduleEvent.getSettings());
        this.logger.info("dispatched fail-over event for test [" + ((StokpopHelloEventContext)this.eventContext).getTestContext().getTestRunId() + "] with parsed settings: " + parsedSettings);
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    private static void sayStatic(String something) {
        System.out.printf("[%s] %s%n", StokpopHelloEvent.class.getSimpleName(), something);
    }

    static {
        StokpopHelloEvent.sayStatic("Class loaded");
    }

    static enum AllowedCustomEvents {
        failOver("fail-over"),
        scaleDown("scale-down"),
        heapdump("heapdump"),
        restart("restart"),
        helloWorld("hello-world");

        private final String eventName;

        private AllowedCustomEvents(String eventName) {
            this.eventName = eventName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public static Stream<AllowedCustomEvents> stream() {
            return Stream.of(AllowedCustomEvents.values());
        }

        public boolean hasEventName(String name) {
            return this.eventName.equals(name);
        }
    }
}

