/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.helloworld.event;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import nl.stokpop.eventscheduler.api.config.EventConfig;
import nl.stokpop.eventscheduler.api.config.TestContext;
import nl.stokpop.helloworld.event.StokpopHelloEventContext;

@NotThreadSafe
public class StokpopHelloEventConfig
extends EventConfig {
    private String myRestService;
    private int helloInitialSleepSeconds = 4;
    private String helloMessage = "Default Hello Message";
    private String myCredentials;
    private String myEventTags;
    private String actuatorPropPrefix = "actuator";
    private String actuatorBaseUrl;
    private String actuatorEnvProperties;

    public void setMyRestService(String myRestService) {
        this.myRestService = myRestService;
    }

    public void setHelloInitialSleepSeconds(int helloInitialSleepSeconds) {
        this.helloInitialSleepSeconds = helloInitialSleepSeconds;
    }

    public void setHelloMessage(String helloMessage) {
        this.helloMessage = helloMessage;
    }

    public void setMyCredentials(String myCredentials) {
        this.myCredentials = myCredentials;
    }

    public void setMyEventTags(String myEventTags) {
        this.myEventTags = myEventTags;
    }

    private List<String> createEnvProps() {
        return this.actuatorEnvProperties == null ? Collections.emptyList() : Arrays.asList(this.actuatorEnvProperties.split(","));
    }

    public StokpopHelloEventContext toContext() {
        List<String> envProps = this.createEnvProps();
        return new StokpopHelloEventContext(super.toContext(), this.myRestService, Duration.ofSeconds(this.helloInitialSleepSeconds), this.helloMessage, this.myCredentials, this.myEventTags, this.actuatorPropPrefix, this.actuatorBaseUrl, envProps);
    }

    public StokpopHelloEventContext toContext(TestContext override) {
        List<String> envProps = this.createEnvProps();
        return new StokpopHelloEventContext(super.toContext(override), this.myRestService, Duration.ofSeconds(this.helloInitialSleepSeconds), this.helloMessage, this.myCredentials, this.myEventTags, this.actuatorPropPrefix, this.actuatorBaseUrl, envProps);
    }

    public String toString() {
        return "StokpopHelloEventConfig{myRestService='" + this.myRestService + "', helloInitialSleepSeconds=" + this.helloInitialSleepSeconds + ", helloMessage='" + this.helloMessage + "', myCredentials='" + this.myCredentials + "', myEventTags='" + this.myEventTags + "', actuatorPropPrefix='" + this.actuatorPropPrefix + "', actuatorBaseUrl='" + this.actuatorBaseUrl + "', actuatorEnvProperties='" + this.actuatorEnvProperties + "'} " + super.toString();
    }

    public String getActuatorBaseUrl() {
        return this.actuatorBaseUrl;
    }

    public void setActuatorBaseUrl(String actuatorBaseUrl) {
        this.actuatorBaseUrl = actuatorBaseUrl;
    }

    public String getActuatorEnvProperties() {
        return this.actuatorEnvProperties;
    }

    public void setActuatorEnvProperties(String actuatorEnvProperties) {
        this.actuatorEnvProperties = actuatorEnvProperties;
    }

    public String getActuatorPropPrefix() {
        return this.actuatorPropPrefix;
    }

    public void setActuatorPropPrefix(String actuatorPropPrefix) {
        this.actuatorPropPrefix = actuatorPropPrefix;
    }
}

