/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.event.wiremock;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import nl.stokpop.event.wiremock.WiremockClient;
import nl.stokpop.event.wiremock.WiremockEventException;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventAdapter;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.TestContext;

public class WiremockEvent
extends EventAdapter {
    public static final String PROP_WIREMOCK_FILES_DIR = "wiremockFilesDir";
    public static final String PROP_WIREMOCK_URL = "wiremockUrl";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String EVENT_WIREMOCK_CHANGE_DELAY = "wiremock-change-delay";
    private static final Set<String> ALLOWED_PROPERTIES = WiremockEvent.setOf((String[])new String[]{"wiremockFilesDir", "wiremockUrl", "useProxy"});
    private static final Set<String> ALLOWED_CUSTOM_EVENTS = WiremockEvent.setOf((String[])new String[]{"wiremock-change-delay"});
    private List<WiremockClient> clients;
    private File rootDir;

    public WiremockEvent(String eventName, TestContext testContext, EventProperties eventProperties, EventLogger logger) {
        super(eventName, testContext, eventProperties, logger);
    }

    public void beforeTest() {
        this.logger.info("before test [" + this.testContext.getTestRunId() + "]");
        String filesDir = this.eventProperties.getProperty(PROP_WIREMOCK_FILES_DIR);
        if (filesDir == null) {
            throw new WiremockEventException(String.format("property %s is not set", PROP_WIREMOCK_FILES_DIR));
        }
        this.rootDir = new File(filesDir);
        if (!this.rootDir.exists()) {
            throw new WiremockEventException(String.format("directory not found: %s", this.rootDir));
        }
        String wiremockUrl = this.eventProperties.getProperty(PROP_WIREMOCK_URL);
        boolean useProxy = Boolean.parseBoolean(this.eventProperties.getPropertyOrDefault(PROP_USE_PROXY, "false"));
        if (wiremockUrl == null) {
            throw new WiremockEventException(String.format("property %s is not set", PROP_WIREMOCK_URL));
        }
        this.clients = Arrays.stream(wiremockUrl.split(",")).map(url -> new WiremockClient((String)url, this.logger, useProxy)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private void importAllWiremockFiles(WiremockClient client, File[] files, Map<String, String> replacements) {
        Arrays.stream(files).peek(file -> this.logger.info("check " + file)).filter(file -> !file.isDirectory()).filter(File::canRead).peek(file -> this.logger.info("import " + file)).map(this::readContents).filter(Objects::nonNull).forEach(fileContents -> client.uploadFileWithReplacements((String)fileContents, replacements));
    }

    private String readContents(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error("reading file: " + file);
            return null;
        }
    }

    public void customEvent(CustomEvent scheduleEvent) {
        String eventName = scheduleEvent.getName();
        if (EVENT_WIREMOCK_CHANGE_DELAY.equalsIgnoreCase(eventName)) {
            this.injectDelayFromSettings(scheduleEvent);
        } else {
            this.logger.debug("ignoring unknown event [" + eventName + "]");
        }
    }

    private void injectDelayFromSettings(CustomEvent scheduleEvent) {
        Map<String, String> replacements = WiremockEvent.parseSettings(scheduleEvent.getSettings());
        if (this.rootDir != null && this.clients != null) {
            this.clients.forEach(client -> this.importAllWiremockFiles((WiremockClient)client, this.rootDir.listFiles(), replacements));
        }
    }

    static Map<String, String> parseSettings(String eventSettings) {
        if (eventSettings == null || eventSettings.trim().length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(eventSettings.split(";")).map(s -> s.split("=")).collect(Collectors.toMap(k -> k[0], v -> ((String[])v).length == 2 ? v[1] : ""));
    }

    public Collection<String> allowedProperties() {
        return ALLOWED_PROPERTIES;
    }

    public Collection<String> allowedCustomEvents() {
        return ALLOWED_CUSTOM_EVENTS;
    }
}

