/*
 * Decompiled with CFR 0.152.
 */
package stormlantern.consul.client.dao;

import java.util.UUID;
import org.parboiled.common.Base64;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function6;
import scala.Function7;
import scala.Function8;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.util.control.NonFatal$;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.JsonFormat;
import spray.json.JsonWriter;
import spray.json.package$;
import stormlantern.consul.client.dao.BinaryData;
import stormlantern.consul.client.dao.ConsulHttpProtocol;
import stormlantern.consul.client.dao.HealthCheck;
import stormlantern.consul.client.dao.HttpHealthCheck;
import stormlantern.consul.client.dao.HttpHealthCheck$;
import stormlantern.consul.client.dao.KeyData$;
import stormlantern.consul.client.dao.ScriptHealthCheck;
import stormlantern.consul.client.dao.ScriptHealthCheck$;
import stormlantern.consul.client.dao.ServiceInstance;
import stormlantern.consul.client.dao.ServiceRegistration$;
import stormlantern.consul.client.dao.SessionCreation$;
import stormlantern.consul.client.dao.SessionInfo$;
import stormlantern.consul.client.dao.TTLHealthCheck;
import stormlantern.consul.client.dao.TTLHealthCheck$;

public abstract class ConsulHttpProtocol$class {
    public static void $init$(ConsulHttpProtocol $this) {
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$uuidFormat_$eq((JsonFormat)new JsonFormat<UUID>($this){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public UUID read(JsValue json) {
                JsValue jsValue = json;
                if (!(jsValue instanceof JsString)) throw package$.MODULE$.deserializationError(new StringBuilder().append((Object)"Expected UUID as JsString, but got ").append((Object)jsValue).toString(), package$.MODULE$.deserializationError$default$2(), package$.MODULE$.deserializationError$default$3());
                JsString jsString = (JsString)jsValue;
                String uuid = jsString.value();
                try {
                    return UUID.fromString(uuid);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) throw package$.MODULE$.deserializationError(new StringBuilder().append((Object)"Expected UUID, but got ").append((Object)uuid).toString(), package$.MODULE$.deserializationError$default$2(), package$.MODULE$.deserializationError$default$3());
                    throw throwable;
                }
            }

            public JsValue write(UUID obj) {
                return new JsString(obj.toString());
            }
        });
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$binaryDataFormat_$eq((JsonFormat)new JsonFormat<BinaryData>($this){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public BinaryData read(JsValue json) {
                JsValue jsValue = json;
                if (!(jsValue instanceof JsString)) throw package$.MODULE$.deserializationError(new StringBuilder().append((Object)"Expected base64 encoded binary data as JsString, but got ").append((Object)jsValue).toString(), package$.MODULE$.deserializationError$default$2(), package$.MODULE$.deserializationError$default$3());
                JsString jsString = (JsString)jsValue;
                String data = jsString.value();
                try {
                    return new BinaryData(Base64.rfc2045().decode(data));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) throw package$.MODULE$.deserializationError(new StringBuilder().append((Object)"Expected base64 encoded binary data, but got ").append((Object)data).toString(), package$.MODULE$.deserializationError$default$2(), package$.MODULE$.deserializationError$default$3());
                    throw throwable;
                }
            }

            public JsValue write(BinaryData obj) {
                return new JsString(Base64.rfc2045().encodeToString(obj.data(), false));
            }
        });
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$serviceFormat_$eq($this.jsonFormat((Function7)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ServiceInstance apply(String node, String address, String serviceId, String serviceName, Option<Set<String>> serviceTags, String serviceAddress, int servicePort) {
                return new ServiceInstance(node, address, serviceId, serviceName, (Set<String>)((Set)serviceTags.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<String> apply() {
                        return Predef$.MODULE$.Set().empty();
                    }
                })), serviceAddress, servicePort);
            }
        }, "Node", "Address", "ServiceID", "ServiceName", "ServiceTags", "ServiceAddress", "ServicePort", (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat(), $this.optionFormat((JsonFormat)$this.immSetFormat((JsonFormat)$this.StringJsonFormat())), (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.IntJsonFormat()));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$httpCheckFormat_$eq($this.jsonFormat((Function2)HttpHealthCheck$.MODULE$, "HTTP", "Interval", (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat()));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$scriptCheckFormat_$eq($this.jsonFormat((Function2)ScriptHealthCheck$.MODULE$, "Script", "Interval", (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat()));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$ttlCheckFormat_$eq($this.jsonFormat((Function1)TTLHealthCheck$.MODULE$, "TTL", (JsonFormat)$this.StringJsonFormat()));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$checkWriter_$eq($this.lift((JsonWriter)new JsonWriter<HealthCheck>($this){
            private final /* synthetic */ ConsulHttpProtocol $outer;

            public JsValue write(HealthCheck obj) {
                HealthCheck healthCheck;
                block5: {
                    JsValue jsValue;
                    block3: {
                        block4: {
                            block2: {
                                healthCheck = obj;
                                if (!(healthCheck instanceof ScriptHealthCheck)) break block2;
                                ScriptHealthCheck scriptHealthCheck = (ScriptHealthCheck)healthCheck;
                                jsValue = package$.MODULE$.pimpAny((Object)scriptHealthCheck).toJson(this.$outer.scriptCheckFormat());
                                break block3;
                            }
                            if (!(healthCheck instanceof HttpHealthCheck)) break block4;
                            HttpHealthCheck httpHealthCheck = (HttpHealthCheck)healthCheck;
                            jsValue = package$.MODULE$.pimpAny((Object)httpHealthCheck).toJson(this.$outer.httpCheckFormat());
                            break block3;
                        }
                        if (!(healthCheck instanceof TTLHealthCheck)) break block5;
                        TTLHealthCheck tTLHealthCheck = (TTLHealthCheck)healthCheck;
                        jsValue = package$.MODULE$.pimpAny((Object)tTLHealthCheck).toJson(this.$outer.ttlCheckFormat());
                    }
                    return jsValue;
                }
                throw new MatchError((Object)healthCheck);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$serviceRegistrationFormat_$eq($this.jsonFormat((Function6)ServiceRegistration$.MODULE$, "Name", "ID", "Tags", "Address", "Port", "Check", (JsonFormat)$this.StringJsonFormat(), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), (JsonFormat)$this.immSetFormat((JsonFormat)$this.StringJsonFormat()), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), $this.optionFormat((JsonFormat)$this.LongJsonFormat()), $this.optionFormat($this.checkWriter())));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$sessionCreationFormat_$eq($this.jsonFormat((Function6)SessionCreation$.MODULE$, "LockDelay", "Name", "Node", "Checks", "Behavior", "TTL", $this.optionFormat((JsonFormat)$this.StringJsonFormat()), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), (JsonFormat)$this.immSetFormat($this.checkWriter()), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), $this.optionFormat((JsonFormat)$this.StringJsonFormat())));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$keyDataFormat_$eq($this.jsonFormat((Function7)KeyData$.MODULE$, "Key", "CreateIndex", "ModifyIndex", "LockIndex", "Flags", "Value", "Session", (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.LongJsonFormat(), (JsonFormat)$this.LongJsonFormat(), (JsonFormat)$this.LongJsonFormat(), (JsonFormat)$this.LongJsonFormat(), $this.binaryDataFormat(), $this.optionFormat($this.uuidFormat())));
        $this.stormlantern$consul$client$dao$ConsulHttpProtocol$_setter_$sessionInfoFormat_$eq($this.jsonFormat((Function8)SessionInfo$.MODULE$, "LockDelay", "Checks", "Node", "ID", "CreateIndex", "Name", "Behavior", "TTL", (JsonFormat)$this.LongJsonFormat(), (JsonFormat)$this.immSetFormat((JsonFormat)$this.StringJsonFormat()), (JsonFormat)$this.StringJsonFormat(), $this.uuidFormat(), (JsonFormat)$this.LongJsonFormat(), $this.optionFormat((JsonFormat)$this.StringJsonFormat()), (JsonFormat)$this.StringJsonFormat(), (JsonFormat)$this.StringJsonFormat()));
    }
}

