/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="multicast-group")
public class MulticastGroupConfig {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The multicast group. This can be the CoAP broadcast address '224.0.1.187' for IPv4, 'FF0X::FD' for IPv6, or a CoAP IPv6 multicast address.")
    @Example(value="224.0.1.187")
    public String group;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The network interface to use for this multicast group.")
    @Example(value="eth0")
    public String networkInterface;

    public MulticastGroupConfig() {
    }

    public MulticastGroupConfig(String group, String networkInterface) {
        this.group = group;
        this.networkInterface = networkInterface;
    }

    public String toString() {
        return "MulticastGroupConfig { " + this.group + (this.networkInterface != null ? "|" + this.networkInterface + " }" : " }");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MulticastGroupConfig rhs = (MulticastGroupConfig)obj;
        return new EqualsBuilder().append((Object)this.group, (Object)rhs.group).append((Object)this.networkInterface, (Object)rhs.networkInterface).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.group).append((Object)this.networkInterface).toHashCode();
    }
}

