/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class BlockwiseParams
implements VisitableConfig {
    @Parameter
    @Optional(defaultValue="512")
    @Summary(value="The block size [bytes] to use when doing a blockwise transfer. This value serves as the upper limit for block size in blockwise transfers.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer preferredBlockSize = null;
    @Parameter
    @Optional(defaultValue="1024")
    @Summary(value="The maximum payload size [bytes] that can be transferred in a single message, i.e. without requiring a blockwise transfer. This value cannot exceed the network's MTU.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxMessageSize = null;
    @Parameter
    @Optional(defaultValue="8192")
    @Summary(value="The maximum size [bytes] of a resource body that will be accepted as the payload of a POST/PUT or the response to a GET request in a transparent blockwise transfer.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxResourceBodySize = null;
    @Parameter
    @Optional(defaultValue="5m")
    @Summary(value=" The maximum amount of time allowed between transfers of individual blocks in a blockwise transfer, before the blockwise transfer state is discarded.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String statusLifetime = null;
    @Parameter
    @Optional(defaultValue="5s")
    @Summary(value="The interval for removing expired/stale blockwise entries.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String statusInterval = null;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="When activated the the Block1 option should be included in the error-responses.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean strictBlock1Option = false;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="When activated the Block2 option is also included when client requests early \nblockwise negotiation but the response can be sent on one packet.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean strictBlock2Option = false;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="When activated CoAP client will try to use block mode or adapt \nthe block size when receiving a 4.13 Entity too large response code.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean entityTooLargeFailover = true;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BlockwiseParams rhs = (BlockwiseParams)obj;
        return new EqualsBuilder().append(this.entityTooLargeFailover, rhs.entityTooLargeFailover).append((Object)this.maxMessageSize, (Object)rhs.maxMessageSize).append((Object)this.maxResourceBodySize, (Object)rhs.maxResourceBodySize).append((Object)this.preferredBlockSize, (Object)rhs.preferredBlockSize).append((Object)this.statusInterval, (Object)rhs.statusInterval).append((Object)this.statusLifetime, (Object)rhs.statusLifetime).append(this.strictBlock1Option, rhs.strictBlock1Option).append(this.strictBlock2Option, rhs.strictBlock2Option).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 39).append(this.entityTooLargeFailover).append((Object)this.maxMessageSize).append((Object)this.maxResourceBodySize).append((Object)this.preferredBlockSize).append((Object)this.statusInterval).append((Object)this.statusLifetime).append(this.strictBlock1Option).append(this.strictBlock2Option).toHashCode();
    }
}

