/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import nl.teslanet.mule.connectors.coap.internal.client.CoapRequestBuilder;
import nl.teslanet.mule.connectors.coap.internal.client.ResponseProcessingStrategy;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalRequestException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation
implements CoapHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ObserveRelation.class.getCanonicalName());
    private final String observerName;
    private final CoapClient coapClient;
    private final CoapRequestBuilder requestBuilder;
    private final ResponseProcessingStrategy processor;
    private CoapObserveRelation coapRelation = null;

    ObserveRelation(String observerName, CoapClient coapClient, CoapRequestBuilder requestBuilder, ResponseProcessingStrategy processor) {
        this.observerName = observerName;
        this.coapClient = coapClient;
        this.requestBuilder = requestBuilder;
        this.processor = processor;
    }

    public synchronized void start() {
        try {
            this.coapRelation = this.sendObserveRequest();
            LOGGER.info("{} has started.", (Object)this);
        }
        catch (InternalInvalidOptionValueException | InternalInvalidRequestCodeException | InternalRequestException | InternalUnkownOptionException | InternalUriException e) {
            LOGGER.error(String.format("%s failed to recreate relation with server.", this), (Throwable)e);
        }
    }

    public synchronized void stop() {
        if (this.coapRelation != null) {
            this.coapRelation.proactiveCancel();
            this.coapRelation = null;
            LOGGER.info("{} has stopped.", (Object)this);
        }
    }

    public synchronized void stop(boolean confirmable) {
        if (this.coapRelation != null) {
            this.coapRelation.setConfirmable(confirmable);
            this.coapRelation.proactiveCancel();
            this.coapRelation = null;
            LOGGER.info("{} has stopped.", (Object)this);
        }
    }

    public void onError() {
        LOGGER.warn("{} failed to observe, trying to restore relation with server...", (Object)this);
        if (this.coapRelation != null) {
            if (this.coapRelation.isCanceled()) {
                try {
                    this.coapRelation = this.sendObserveRequest();
                }
                catch (InternalInvalidOptionValueException | InternalInvalidRequestCodeException | InternalRequestException | InternalUnkownOptionException | InternalUriException e) {
                    LOGGER.error(String.format("%s failed to observe, trying to restore relation with server...", this), (Throwable)e);
                }
                if (this.coapRelation != null) {
                    LOGGER.info("{} relation with server recreated.", (Object)this);
                } else {
                    LOGGER.error("{} failed to recreate relation with server.", (Object)this);
                }
            } else if (this.coapRelation.reregister()) {
                LOGGER.info("{} reregistered on server.", (Object)this);
            } else {
                LOGGER.error("{} failed to reregister on server.", (Object)this);
            }
        }
        try {
            this.processor.process(this.requestBuilder, null);
        }
        catch (InternalResponseException e) {
            LOGGER.error(String.format("%s error processing failed.", this), (Throwable)e);
        }
    }

    public void onLoad(CoapResponse response) {
        try {
            this.processor.process(this.requestBuilder, response);
        }
        catch (InternalResponseException e) {
            LOGGER.error(String.format("%s notification processing failed.", this), (Throwable)e);
        }
    }

    private CoapObserveRelation sendObserveRequest() throws InternalInvalidRequestCodeException, InternalUriException, InternalRequestException, InternalInvalidOptionValueException, InternalUnkownOptionException {
        return this.coapClient.observe(this.requestBuilder.build(), (CoapHandler)this);
    }

    public String toString() {
        return this.observerName;
    }
}

