/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapRequestOptionsAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapResponseAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapResponseOptionsAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.client.CoapRequestBuilder;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidHandlerException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidMessageTypeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidResponseCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import nl.teslanet.mule.connectors.coap.internal.options.MediaTypeMediator;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.eclipse.californium.core.CoapResponse;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public class ResponseProcessor {
    private static ConcurrentHashMap<String, ResponseProcessor> registry = new ConcurrentHashMap();
    private String handlerName = null;
    private CopyOnWriteArrayList<SourceCallback<InputStream, CoapResponseAttributes>> listeners = new CopyOnWriteArrayList();

    public ResponseProcessor(String handlerName) {
        this.handlerName = handlerName;
    }

    public static ResponseProcessor getResponseProcessor(String handlerName) throws InternalInvalidHandlerException {
        if (handlerName == null || handlerName.isEmpty()) {
            throw new InternalInvalidHandlerException("empty response handler name not allowed");
        }
        registry.putIfAbsent(handlerName, new ResponseProcessor(handlerName));
        return registry.get(handlerName);
    }

    public static void removeHandler(String handlerName) throws InternalInvalidHandlerException {
        if (handlerName == null || handlerName.isEmpty()) {
            throw new InternalInvalidHandlerException("empty response handler name not allowed");
        }
        registry.remove(handlerName);
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    synchronized void addListener(SourceCallback<InputStream, CoapResponseAttributes> listener) {
        this.listeners.add(listener);
    }

    void removeListener(SourceCallback<InputStream, CoapResponseAttributes> listener) {
        this.listeners.remove(listener);
    }

    public List<SourceCallback<InputStream, CoapResponseAttributes>> getListeners() {
        return this.listeners;
    }

    public static void processMuleFlow(String localAddress, CoapRequestBuilder requestBuilder, CoapResponse response, ResponseProcessor processor) throws InternalResponseException {
        CoapResponseAttributesImpl responseAttributes;
        try {
            responseAttributes = ResponseProcessor.createReceivedResponseAttributes(localAddress, requestBuilder, response);
        }
        catch (InternalInvalidMessageTypeException | InternalInvalidOptionValueException | InternalInvalidResponseCodeException | InternalUriException e) {
            throw new InternalResponseException("cannot proces received response", e);
        }
        for (SourceCallback<InputStream, CoapResponseAttributes> callback : processor.getListeners()) {
            ResponseProcessor.callMuleFlow(responseAttributes, response, callback);
        }
    }

    public static void processMuleFlow(String localAddress, CoapRequestBuilder requestBuilder, CoapResponse response, SourceCallback<InputStream, CoapResponseAttributes> callback) throws InternalResponseException {
        CoapResponseAttributesImpl responseAttributes;
        try {
            responseAttributes = ResponseProcessor.createReceivedResponseAttributes(localAddress, requestBuilder, response);
        }
        catch (InternalInvalidMessageTypeException | InternalInvalidOptionValueException | InternalInvalidResponseCodeException | InternalUriException e) {
            throw new InternalResponseException("cannot proces received response", e);
        }
        ResponseProcessor.callMuleFlow(responseAttributes, response, callback);
    }

    private static void callMuleFlow(CoapResponseAttributesImpl responseAttributes, CoapResponse response, SourceCallback<InputStream, CoapResponseAttributes> callback) {
        SourceCallbackContext requestcontext = callback.createContext();
        if (response != null) {
            byte[] responsePayload = response.getPayload();
            callback.handle(Result.builder().output((Object)new ByteArrayInputStream(responsePayload)).attributes((Object)responseAttributes).mediaType(MediaTypeMediator.toMediaType(response.getOptions().getContentFormat())).build(), requestcontext);
        } else {
            callback.handle(Result.builder().attributes((Object)responseAttributes).mediaType(MediaType.ANY).build(), requestcontext);
        }
    }

    static CoapResponseAttributesImpl createReceivedResponseAttributes(String localAddress, CoapRequestBuilder requestBuilder, CoapResponse response) throws InternalInvalidMessageTypeException, InternalInvalidResponseCodeException, InternalInvalidOptionValueException, InternalUriException {
        CoapResponseAttributesImpl attributes = new CoapResponseAttributesImpl();
        attributes.setLocalAddress(localAddress);
        attributes.setRequestType(requestBuilder.buildMessageType().name());
        attributes.setRequestCode(requestBuilder.buildRequestCode().name());
        attributes.setRequestUriObject(requestBuilder.buildResourceUri());
        attributes.setRequestOptions(new CoapRequestOptionsAttributesImpl(requestBuilder.buildOptionSet()));
        if (response == null) {
            attributes.setResult(nl.teslanet.mule.connectors.coap.api.attributes.Result.NO_RESPONSE);
        } else {
            attributes.setResult(AttributeUtils.toResult(response.getCode()));
            attributes.setResponseType(AttributeUtils.toMessageTypeAttribute(response.advanced().getType()).name());
            attributes.setResponseCode(AttributeUtils.toResponseCodeAttribute(response.getCode()).name());
            attributes.setRemoteAddress(response.advanced().getSourceContext().getPeerAddress().toString());
            attributes.setNotification(response.advanced().isNotification());
            attributes.setResponseOptions(new CoapResponseOptionsAttributesImpl(response.getOptions()));
            attributes.setLocationUri(MessageUtils.uriString(attributes.getResponseOptions().getLocationPath(), attributes.getResponseOptions().getLocationQuery()));
        }
        return attributes;
    }
}

