/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.config;

import java.net.InetSocketAddress;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.SocketParams;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.options.AcceptOtherOption;
import nl.teslanet.mule.connectors.coap.api.config.options.OptionParams;
import nl.teslanet.mule.connectors.coap.internal.GlobalConfig;
import nl.teslanet.mule.connectors.coap.internal.config.ConfigurationVisitor;
import nl.teslanet.mule.connectors.coap.internal.endpoint.EndpointOptionRegistry;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.eclipse.californium.core.network.CoapEndpoint;

public abstract class EndpointConfigVisitor
extends ConfigurationVisitor {
    private String endpointName;
    private InetSocketAddress localAddress = null;
    protected CoapEndpoint.Builder endpointBuilder = new CoapEndpoint.Builder();
    private boolean reuseAddress = false;

    @Override
    public void visit(OptionParams toVisit) {
        EndpointOptionRegistry registry = new EndpointOptionRegistry();
        for (AcceptOtherOption accept : toVisit.getAcceptOtherOptions()) {
            GlobalConfig.getOtherOptionDefinition(accept.getAlias()).ifPresent(registry::add);
        }
        this.endpointBuilder.setOptionRegistry((OptionRegistry)registry);
    }

    @Override
    public void visit(AbstractEndpoint toVisit) throws ConfigException {
        super.visit(toVisit);
        this.endpointName = toVisit.configName;
    }

    @Override
    public void visit(SocketParams toVisit) {
        super.visit(toVisit);
        int port = toVisit.bindToPort != null ? toVisit.bindToPort : 0;
        this.localAddress = toVisit.bindToHost != null ? new InetSocketAddress(toVisit.bindToHost, port) : new InetSocketAddress(port);
        this.reuseAddress = toVisit.reuseAddress;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public abstract CoapEndpoint getEndpoint() throws EndpointConstructionException;
}

