/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.options;

import nl.teslanet.mule.connectors.coap.api.binary.BytesValue;
import nl.teslanet.mule.connectors.coap.api.options.OptionUtils;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;

public class DefaultBytesValue
extends BytesValue {
    private static final long serialVersionUID = 1L;
    private static final String MSG_PREFIX_CONSTRUCT_ERROR = "Cannot construct bytes value, ";
    private static final String MSG_POSTFIX_CONSTRUCT_ERROR = " } is invalid.";
    protected final byte[] value;

    public DefaultBytesValue(DefaultBytesValue bytes) {
        this.value = bytes == null ? OptionUtils.EMPTY_BYTES : bytes.value;
    }

    public DefaultBytesValue(byte[] bytes) {
        this.value = bytes == null || bytes.length == 0 ? OptionUtils.EMPTY_BYTES : (byte[])bytes.clone();
    }

    public DefaultBytesValue(String string) throws OptionValueException {
        this.value = OptionUtils.toBytes(string);
    }

    protected DefaultBytesValue(String string, int min, int max) throws OptionValueException {
        this.value = OptionUtils.toBytes(string, min, max);
    }

    public DefaultBytesValue(String string, int radix) throws OptionValueException {
        if (string == null || string.length() == 0) {
            this.value = OptionUtils.EMPTY_BYTES;
        } else {
            try {
                long longValue = Long.parseLong(string, radix);
                this.value = OptionUtils.toBytes(longValue, 0, 8);
            }
            catch (NumberFormatException | OptionValueException e) {
                throw new OptionValueException("Cannot construct bytes value, string value of { " + string + " } using radix {" + radix + MSG_POSTFIX_CONSTRUCT_ERROR);
            }
        }
    }

    public DefaultBytesValue(int intValue) {
        this.value = OptionUtils.toBytes(intValue);
    }

    public DefaultBytesValue(long longValue) {
        this.value = OptionUtils.toBytes(longValue);
    }

    @Override
    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    @Override
    public long getValueAsNumber() {
        return OptionUtils.toLong(this.value);
    }

    @Override
    public String getValueAsString() {
        return OptionUtils.toString(this.value);
    }

    @Override
    public String getValueAsHex() {
        return OptionUtils.toHexString(this.value);
    }

    public static DefaultBytesValue valueOf(byte[] bytes) throws OptionValueException {
        return new DefaultBytesValue(bytes);
    }

    public static DefaultBytesValue valueOf(int intValue) throws OptionValueException {
        return new DefaultBytesValue(intValue);
    }

    public static DefaultBytesValue valueOf(long longValue) throws OptionValueException {
        return new DefaultBytesValue(longValue);
    }

    public static DefaultBytesValue valueOf(String string) throws OptionValueException {
        return new DefaultBytesValue(string);
    }

    public static DefaultBytesValue valueOf(String string, int radix) throws OptionValueException {
        return new DefaultBytesValue(string, radix);
    }
}

