/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.options;

import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;
import nl.teslanet.mule.connectors.coap.internal.options.DefaultBytesValue;

public class DefaultEntityTag
extends DefaultBytesValue {
    private static final long serialVersionUID = 1L;
    private static final String MSG_PREFIX_CONSTRUCT_ERROR = "Cannot construct Entity-tag value, ";
    private static final String MSG_POSTFIX_CONSTRUCT_ERROR = " } is invalid.";

    public DefaultEntityTag(byte[] bytes) throws OptionValueException {
        super(bytes);
        this.checkValid();
    }

    public DefaultEntityTag(String string) throws OptionValueException {
        super(string, 1, 8);
        this.checkValid();
    }

    public DefaultEntityTag(String string, int radix) throws OptionValueException {
        super(string, radix);
        this.checkValid();
    }

    public DefaultEntityTag(int intValue) throws OptionValueException {
        super(intValue);
        this.checkValid();
    }

    public DefaultEntityTag(long longValue) throws OptionValueException {
        super(longValue);
        this.checkValid();
    }

    public DefaultEntityTag(DefaultBytesValue bytes) throws OptionValueException {
        super(bytes);
        this.checkValid();
    }

    private void checkValid() throws OptionValueException {
        if (this.value.length == 0 || this.value.length > 8) {
            throw new OptionValueException("Cannot construct Entity-tag value, must be between 1..8 bytes. Actual length is { " + this.value.length + MSG_POSTFIX_CONSTRUCT_ERROR);
        }
    }

    public static DefaultEntityTag valueOf(byte[] bytes) throws OptionValueException {
        return new DefaultEntityTag(bytes);
    }

    public static DefaultEntityTag valueOf(int intValue) throws OptionValueException {
        return new DefaultEntityTag(intValue);
    }

    public static DefaultEntityTag valueOf(long longValue) throws OptionValueException {
        return new DefaultEntityTag(longValue);
    }

    public static DefaultEntityTag valueOf(String string) throws OptionValueException {
        return new DefaultEntityTag(string);
    }

    public static DefaultEntityTag valueOf(String string, int radix) throws OptionValueException {
        return new DefaultEntityTag(string, radix);
    }
}

