/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceUriException;
import nl.teslanet.mule.connectors.coap.internal.server.RequestCodeFlags;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class OperationalListener {
    String uriPattern;
    RequestCodeFlags requestCodeFlags = null;
    SourceCallback<InputStream, CoapRequestAttributes> callback = null;

    public OperationalListener(String uriPattern, RequestCodeFlags flags, SourceCallback<InputStream, CoapRequestAttributes> callback) throws InternalResourceUriException {
        this.setUriPattern(uriPattern);
        this.setRequestCodeFlags(flags);
        this.setCallback(callback);
    }

    private void setRequestCodeFlags(RequestCodeFlags flags) {
        this.requestCodeFlags = flags;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) throws InternalResourceUriException {
        int wildcardIndex;
        if (uriPattern == null) {
            throw new InternalResourceUriException("null value is not allowed.");
        }
        this.uriPattern = uriPattern.trim();
        if (!this.uriPattern.startsWith("/")) {
            this.uriPattern = "/" + this.uriPattern;
        }
        if ((wildcardIndex = this.uriPattern.indexOf("*")) >= 0 && wildcardIndex < this.uriPattern.length() - 1) {
            throw new InternalResourceUriException("invalid uriPattern { " + uriPattern + " }, wildcard needs to be last character.");
        }
        if (this.uriPattern.length() < 2) {
            throw new InternalResourceUriException("invalid uriPattern { " + uriPattern + " }, uri cannot be empty.");
        }
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getCallback() {
        return this.callback;
    }

    public void setCallback(SourceCallback<InputStream, CoapRequestAttributes> callback) {
        this.callback = callback;
    }

    public RequestCodeFlags getRequestCodeFlags() {
        return this.requestCodeFlags;
    }
}

