/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

public class RequestCodeFlags
implements Comparable<RequestCodeFlags> {
    private static final int GET_FLAG = 1;
    private static final int POST_FLAG = 2;
    private static final int PUT_FLAG = 4;
    private static final int DELETE_FLAG = 8;
    private static final int FETCH_FLAG = 16;
    private static final int PATCH_FLAG = 32;
    private static final int IPATCH_FLAG = 64;
    private int flags = 0;

    public RequestCodeFlags() {
    }

    public RequestCodeFlags(RequestCodeFlags original) {
        if (original != null) {
            this.setGet(original.isGet());
            this.setPost(original.isPost());
            this.setPut(original.isPut());
            this.setDelete(original.isDelete());
            this.setFetch(original.isFetch());
            this.setPatch(original.isPatch());
            this.setIpatch(original.isIpatch());
        }
    }

    public RequestCodeFlags(boolean getFlag, boolean postFlag, boolean putFlag, boolean deleteFlag, boolean fetchFlag, boolean patchFlag, boolean ipatchFlag) {
        this.setGet(getFlag);
        this.setPost(postFlag);
        this.setPut(putFlag);
        this.setDelete(deleteFlag);
        this.setFetch(fetchFlag);
        this.setPatch(patchFlag);
        this.setIpatch(ipatchFlag);
    }

    public void setGet(boolean flag) {
        this.flags = flag ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isGet() {
        return (this.flags & 1) != 0;
    }

    public boolean isNotGet() {
        return (this.flags & 1) == 0;
    }

    public void setPost(boolean flag) {
        this.flags = flag ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isPost() {
        return (this.flags & 2) != 0;
    }

    public boolean isNotPost() {
        return (this.flags & 2) == 0;
    }

    public void setPut(boolean flag) {
        this.flags = flag ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isPut() {
        return (this.flags & 4) != 0;
    }

    public boolean isNotPut() {
        return (this.flags & 4) == 0;
    }

    public void setDelete(boolean flag) {
        this.flags = flag ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isDelete() {
        return (this.flags & 8) != 0;
    }

    public boolean isNotDelete() {
        return (this.flags & 8) == 0;
    }

    public void setFetch(boolean flag) {
        this.flags = flag ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isFetch() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isNotFetch() {
        return (this.flags & 0x10) == 0;
    }

    public void setPatch(boolean flag) {
        this.flags = flag ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean isPatch() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isNotPatch() {
        return (this.flags & 0x20) == 0;
    }

    public void setIpatch(boolean flag) {
        this.flags = flag ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public boolean isIpatch() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isNotIpatch() {
        return (this.flags & 0x40) == 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RequestCodeFlags)) {
            return false;
        }
        return this.flags == ((RequestCodeFlags)other).flags;
    }

    @Override
    public int compareTo(RequestCodeFlags other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (this.flags < other.flags) {
            return -1;
        }
        if (this.flags > other.flags) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.flags;
    }

    public String toString() {
        StringBuilder bfr = new StringBuilder();
        bfr.append("RequestCodeFlags[ ");
        bfr.append(this.isGet() ? "GET" : "get");
        bfr.append(" ");
        bfr.append(this.isPost() ? "POST" : "post");
        bfr.append(" ");
        bfr.append(this.isPut() ? "PUT" : "put");
        bfr.append(" ");
        bfr.append(this.isDelete() ? "DELETE" : "delete");
        bfr.append(" ");
        bfr.append(this.isFetch() ? "FETCH" : "fetch");
        bfr.append(" ");
        bfr.append(this.isPatch() ? "PATCH" : "patch");
        bfr.append(" ");
        bfr.append(this.isIpatch() ? "IPATCH" : "ipatch");
        bfr.append(" ]");
        return bfr.toString();
    }
}

