/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.teslanet.mule.connectors.coap.api.ResourceConfig;
import nl.teslanet.mule.connectors.coap.api.ResourceParams;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceRegistryException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriPatternException;
import nl.teslanet.mule.connectors.coap.internal.server.OperationalListener;
import nl.teslanet.mule.connectors.coap.internal.server.ServedResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRegistry.class);
    private ConcurrentHashMap<String, ServedResource> servedResources;
    private CopyOnWriteArrayList<OperationalListener> listeners;
    Resource root = null;

    public ResourceRegistry(Resource root) throws InternalResourceRegistryException {
        if (root == null) {
            throw new InternalResourceRegistryException("Cannot construct a ResourceRegistry without root resource.");
        }
        this.root = root;
        this.servedResources = new ConcurrentHashMap();
        this.listeners = new CopyOnWriteArrayList();
    }

    public void add(String parentUri, ResourceConfig resourceDesciption) throws InternalResourceUriException {
        ServedResource resource;
        ServedResource parent = this.getResource(parentUri);
        try {
            resource = new ServedResource(resourceDesciption);
        }
        catch (Exception e) {
            throw new InternalResourceUriException("Resource parameters are invalid", e);
        }
        if (parent == null) {
            this.root.add((Resource)resource);
        } else {
            parent.add(resource);
        }
        this.register(resource);
    }

    public void add(String parentUri, ResourceParams resourceDesciption) throws InternalResourceUriException {
        ServedResource parent = this.getResource(parentUri);
        ServedResource resource = new ServedResource(resourceDesciption);
        if (parent == null) {
            this.root.add((Resource)resource);
        } else {
            parent.add(resource);
        }
        this.register(resource);
    }

    private void register(ServedResource resource) {
        this.servedResources.put(resource.getURI(), resource);
        this.setResourceCallBack(resource);
        for (Resource child : resource.getChildren()) {
            this.register((ServedResource)child);
        }
    }

    public void removeAll() {
        this.remove("/*");
    }

    public void remove(String uriPattern) {
        for (ServedResource resource : this.findResources(uriPattern)) {
            this.unRegister(resource);
        }
    }

    private void unRegister(ServedResource resource) {
        this.servedResources.remove(resource.getURI());
        for (Resource child : resource.getChildren()) {
            this.unRegister((ServedResource)child);
        }
        resource.delete();
    }

    public void add(OperationalListener operationalListener) throws InternalUriPatternException {
        ResourceRegistry.uriHasWildcard(operationalListener.getUriPattern());
        this.listeners.add(operationalListener);
        this.updateResourceCallBack();
    }

    public void remove(OperationalListener listener) {
        this.listeners.remove(listener);
        this.updateResourceCallBack();
    }

    private void updateResourceCallBack() {
        for (Map.Entry<String, ServedResource> e : this.servedResources.entrySet()) {
            this.setResourceCallBack(e.getValue());
        }
    }

    private void setResourceCallBack(ServedResource resource) {
        OperationalListener bestGetListener = null;
        OperationalListener bestPostListener = null;
        OperationalListener bestPutListener = null;
        OperationalListener bestDeleteListener = null;
        OperationalListener bestFetchListener = null;
        OperationalListener bestPatchListener = null;
        OperationalListener bestIpatchListener = null;
        int maxGetMatchlevel = 0;
        int maxPostMatchlevel = 0;
        int maxPutMatchlevel = 0;
        int maxDeleteMatchlevel = 0;
        int maxFetchMatchlevel = 0;
        int maxPatchMatchlevel = 0;
        int maxIpatchMatchlevel = 0;
        for (OperationalListener listener : this.listeners) {
            int matchLevel;
            try {
                matchLevel = ResourceRegistry.matchUri(listener.getUriPattern(), resource.getURI());
            }
            catch (InternalUriPatternException e) {
                LOGGER.error(e.getMessage());
                matchLevel = 0;
            }
            if (matchLevel > maxGetMatchlevel && listener.requestCodeFlags.isGet()) {
                maxGetMatchlevel = matchLevel;
                bestGetListener = listener;
            }
            if (matchLevel > maxPostMatchlevel && listener.requestCodeFlags.isPost()) {
                maxPostMatchlevel = matchLevel;
                bestPostListener = listener;
            }
            if (matchLevel > maxPutMatchlevel && listener.requestCodeFlags.isPut()) {
                maxPutMatchlevel = matchLevel;
                bestPutListener = listener;
            }
            if (matchLevel > maxDeleteMatchlevel && listener.requestCodeFlags.isDelete()) {
                maxDeleteMatchlevel = matchLevel;
                bestDeleteListener = listener;
            }
            if (matchLevel > maxFetchMatchlevel && listener.requestCodeFlags.isFetch()) {
                maxFetchMatchlevel = matchLevel;
                bestFetchListener = listener;
            }
            if (matchLevel > maxPatchMatchlevel && listener.requestCodeFlags.isPatch()) {
                maxPatchMatchlevel = matchLevel;
                bestPatchListener = listener;
            }
            if (matchLevel <= maxIpatchMatchlevel || !listener.requestCodeFlags.isIpatch()) continue;
            maxIpatchMatchlevel = matchLevel;
            bestIpatchListener = listener;
        }
        if (bestGetListener != null) {
            resource.setGetCallback(bestGetListener.getCallback());
        } else {
            resource.setGetCallback(null);
        }
        if (bestPostListener != null) {
            resource.setPostCallback(bestPostListener.getCallback());
        } else {
            resource.setPostCallback(null);
        }
        if (bestPutListener != null) {
            resource.setPutCallback(bestPutListener.getCallback());
        } else {
            resource.setPutCallback(null);
        }
        if (bestDeleteListener != null) {
            resource.setDeleteCallback(bestDeleteListener.getCallback());
        } else {
            resource.setDeleteCallback(null);
        }
        if (bestFetchListener != null) {
            resource.setFetchCallback(bestFetchListener.getCallback());
        } else {
            resource.setFetchCallback(null);
        }
        if (bestPatchListener != null) {
            resource.setPatchCallback(bestPatchListener.getCallback());
        } else {
            resource.setPatchCallback(null);
        }
        if (bestIpatchListener != null) {
            resource.setIpatchCallback(bestIpatchListener.getCallback());
        } else {
            resource.setIpatchCallback(null);
        }
    }

    public ServedResource getResource(String uri) throws InternalResourceUriException {
        if (uri == null || uri.length() == 0 || uri.equals("/")) {
            return null;
        }
        for (Map.Entry<String, ServedResource> e : this.servedResources.entrySet()) {
            if (!uri.equals(e.getKey())) continue;
            return e.getValue();
        }
        throw new InternalResourceUriException("resource { " + uri + " } does not exist.");
    }

    public List<ServedResource> findResources(String uriPattern) {
        ArrayList<ServedResource> found = new ArrayList<ServedResource>();
        for (Map.Entry<String, ServedResource> entry : this.servedResources.entrySet()) {
            try {
                if (ResourceRegistry.matchUri(uriPattern, entry.getKey()) <= 0) continue;
                found.add(entry.getValue());
            }
            catch (InternalUriPatternException e) {
                LOGGER.error(e.getMessage());
                break;
            }
        }
        return found;
    }

    public static int matchUri(String uriPattern, String resourceUri) throws InternalUriPatternException {
        if (ResourceRegistry.uriHasWildcard(uriPattern)) {
            if (resourceUri.startsWith(ResourceRegistry.getUriPath(uriPattern))) {
                return ResourceRegistry.getUriDepth(uriPattern);
            }
        } else if (uriPattern.equals(resourceUri)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public static int getUriDepth(String uri) {
        int count = 0;
        int index = uri.indexOf("/", 0);
        while (index >= 0) {
            index = uri.indexOf("/", index + 1);
            ++count;
        }
        return count;
    }

    public static String getUriPath(String uri) {
        int lastPathSep = uri.lastIndexOf("/");
        if (lastPathSep >= 0) {
            return uri.substring(0, lastPathSep + 1);
        }
        return "/";
    }

    public static String getUriResourceName(String uri) {
        int lastPathSep = uri.lastIndexOf("/");
        if (lastPathSep >= 0) {
            return uri.substring(lastPathSep + 1);
        }
        return "";
    }

    public static boolean uriHasWildcard(String uri) throws InternalUriPatternException {
        int index = uri.indexOf("*");
        if (index == -1) {
            return false;
        }
        if (index < uri.length() - "*".length()) {
            throw new InternalUriPatternException("Wildcard is only allowed on pattern ending", uri);
        }
        return true;
    }

    public static String getParentUri(String uri) {
        int lastPathSep = uri.lastIndexOf("/");
        if (lastPathSep > 0) {
            return uri.substring(0, lastPathSep);
        }
        return "/";
    }
}

