/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.utils;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import nl.teslanet.mule.connectors.coap.api.binary.BytesValue;
import nl.teslanet.mule.connectors.coap.api.config.options.OtherOptionConfig;
import nl.teslanet.mule.connectors.coap.api.options.EntityTag;
import nl.teslanet.mule.connectors.coap.api.options.OptionFormat;
import nl.teslanet.mule.connectors.coap.api.options.OptionUtils;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;
import nl.teslanet.mule.connectors.coap.api.options.OtherOption;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsParams;
import nl.teslanet.mule.connectors.coap.api.options.ResponseOptionsParams;
import nl.teslanet.mule.connectors.coap.api.query.AbstractQueryParam;
import nl.teslanet.mule.connectors.coap.api.query.QueryParam;
import nl.teslanet.mule.connectors.coap.internal.GlobalConfig;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.options.DefaultBytesValue;
import nl.teslanet.mule.connectors.coap.internal.options.DefaultEntityTag;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.option.EmptyOptionDefinition;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OpaqueOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.StringOptionDefinition;
import org.eclipse.californium.elements.util.Bytes;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;

public class MessageUtils {
    private static final String VALUE_INVALID = "value is not valid";

    private MessageUtils() {
    }

    public static void copyOptions(RequestOptionsParams requestOptions, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException {
        MessageUtils.copyIfExists(requestOptions.isIfExists(), optionSet);
        MessageUtils.copyIfMatch(requestOptions.getIfMatchOptions(), optionSet, transformationService);
        MessageUtils.copyEntityTags(requestOptions.getEntityTagOptions(), optionSet, transformationService);
        MessageUtils.copyIfNoneMatch(requestOptions.isIfNoneMatch(), optionSet);
        MessageUtils.copyContentFormat(requestOptions.getContentFormat(), optionSet);
        MessageUtils.copyAccept(requestOptions.getAccept(), optionSet);
        MessageUtils.copyRequireResponseSize(requestOptions.isRequireResponseSize(), optionSet);
        MessageUtils.copyRequestSize(requestOptions.getRequestSize(), optionSet);
    }

    private static void copyIfExists(boolean ifExists, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (ifExists) {
            try {
                optionSet.addIfMatch(OptionUtils.EMPTY_BYTES);
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("If-Exists", VALUE_INVALID, e);
            }
        }
    }

    private static void copyIfMatch(List<EntityTag> ifIfMatchOptions, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException {
        if (ifIfMatchOptions != null) {
            try {
                List<DefaultEntityTag> etags = MessageUtils.toEtagList(ifIfMatchOptions, transformationService);
                for (DefaultEntityTag etag : etags) {
                    optionSet.addIfMatch(etag.getValue());
                }
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("If-Match", VALUE_INVALID, e);
            }
        }
    }

    private static void copyEntityTags(List<EntityTag> entityTagOptions, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException {
        if (entityTagOptions != null) {
            try {
                List<DefaultEntityTag> etags = MessageUtils.toEtagList(entityTagOptions, transformationService);
                for (DefaultEntityTag etag : etags) {
                    optionSet.addETag(etag.getValue());
                }
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("ETag", VALUE_INVALID, e);
            }
        }
    }

    private static void copyIfNoneMatch(boolean ifNoneMatch, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (ifNoneMatch) {
            try {
                optionSet.setIfNoneMatch(true);
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("If-None-Match", VALUE_INVALID, e);
            }
        }
    }

    private static void copyContentFormat(Integer contentFormat, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (contentFormat != null) {
            try {
                optionSet.setContentFormat(contentFormat.intValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Content-Format", VALUE_INVALID, e);
            }
        }
    }

    private static void copyAccept(Integer contentFormat, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (contentFormat != null) {
            try {
                optionSet.setAccept(contentFormat.intValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Accept", VALUE_INVALID, e);
            }
        }
    }

    private static void copyRequireResponseSize(boolean requireResponseSize, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (requireResponseSize) {
            try {
                optionSet.setSize2(0);
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Require-Response-Size", VALUE_INVALID, e);
            }
        }
    }

    private static void copyRequestSize(Integer requestSize, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (requestSize != null) {
            try {
                optionSet.setSize1(requestSize.intValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Request-Size", VALUE_INVALID, e);
            }
        }
    }

    public static void copyOptions(List<OtherOption> otherOptions, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException, InternalUnkownOptionException {
        for (OtherOption otherOption : otherOptions) {
            MessageUtils.addOption(optionSet, otherOption, transformationService);
        }
    }

    public static void copyOptions(ResponseOptionsParams responseOptions, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException {
        MessageUtils.copyEntityTagValue(responseOptions.getEntityTagValue(), optionSet, transformationService);
        MessageUtils.copyContentFormat(responseOptions.getContentFormat(), optionSet);
        MessageUtils.copyMaxAge(responseOptions.getMaxAge(), optionSet);
        MessageUtils.copyLocationPath(responseOptions.getLocationPath(), optionSet);
        MessageUtils.copyLocationQuery(responseOptions.getLocationQuery(), optionSet);
        MessageUtils.copyResponseSize(responseOptions.getResponseSize(), optionSet);
        MessageUtils.copyAcceptableRequestSize(responseOptions.getAcceptableRequestSize(), optionSet);
    }

    public static void copyEntityTagValue(TypedValue<Object> entityTagValue, OptionSet optionSet, TransformationService transformationService) throws InternalInvalidOptionValueException {
        if (entityTagValue != null) {
            Optional<DefaultEntityTag> optionalEtag;
            try {
                optionalEtag = MessageUtils.toOptionalETag(entityTagValue, transformationService);
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("ETag", VALUE_INVALID, e);
            }
            optionalEtag.ifPresent(etag -> optionSet.addETag(etag.getValue()));
        }
    }

    public static void copyMaxAge(Long maxAge, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (maxAge != null) {
            try {
                optionSet.setMaxAge(maxAge.longValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Max-Age", VALUE_INVALID, e);
            }
        }
    }

    public static void copyLocationPath(String locationPath, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (locationPath != null) {
            try {
                optionSet.setLocationPath(locationPath);
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Location-Path", VALUE_INVALID, e);
            }
        }
    }

    public static void copyLocationQuery(List<QueryParam> locationQuery, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (locationQuery != null) {
            for (QueryParam param : locationQuery) {
                try {
                    optionSet.addLocationQuery(param.toString());
                }
                catch (Exception e) {
                    throw new InternalInvalidOptionValueException("Location-Query", VALUE_INVALID, e);
                }
            }
        }
    }

    public static void copyResponseSize(Integer responseSize, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (responseSize != null) {
            try {
                optionSet.setSize2(responseSize.intValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Response-Size", VALUE_INVALID, e);
            }
        }
    }

    public static void copyAcceptableRequestSize(Integer acceptableRequestSize, OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (acceptableRequestSize != null) {
            try {
                optionSet.setSize1(acceptableRequestSize.intValue());
            }
            catch (Exception e) {
                throw new InternalInvalidOptionValueException("Acceptable-Request-Size", VALUE_INVALID, e);
            }
        }
    }

    private static void addOption(OptionSet optionSet, OtherOption otherOption, TransformationService transformationService) throws InternalInvalidOptionValueException, InternalUnkownOptionException {
        optionSet.addOption(MessageUtils.toCfOtherOption(otherOption, GlobalConfig.getOtherOptionDefinition(otherOption.getAlias()).orElseThrow(() -> new InternalUnkownOptionException("Unknown other option: " + otherOption.getAlias())), transformationService));
    }

    public static OptionDefinition toCfOptionDefinition(OtherOptionConfig otherOptionConfig) {
        EmptyOptionDefinition definition;
        switch (otherOptionConfig.getFormat()) {
            case EMPTY: {
                definition = new EmptyOptionDefinition(otherOptionConfig.getNumber(), otherOptionConfig.getAlias());
                break;
            }
            case INTEGER: {
                definition = new IntegerOptionDefinition(otherOptionConfig.getNumber(), otherOptionConfig.getAlias(), otherOptionConfig.isSingleValue(), new int[]{otherOptionConfig.getMinBytes(), otherOptionConfig.getMaxBytes()});
                break;
            }
            case STRING: {
                definition = new StringOptionDefinition(otherOptionConfig.getNumber(), otherOptionConfig.getAlias(), otherOptionConfig.isSingleValue(), new int[]{otherOptionConfig.getMinBytes(), otherOptionConfig.getMaxBytes()});
                break;
            }
            default: {
                definition = new OpaqueOptionDefinition(otherOptionConfig.getNumber(), otherOptionConfig.getAlias(), otherOptionConfig.isSingleValue(), new int[]{otherOptionConfig.getMinBytes(), otherOptionConfig.getMaxBytes()});
            }
        }
        return definition;
    }

    public static boolean isEqual(OptionDefinition left, OptionDefinition right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getName().equals(right.getName()) && left.getFormat() == right.getFormat() && left.getNumber() == right.getNumber() && left.isSingleValue() == right.isSingleValue() && Arrays.equals(left.getValueLengths(), right.getValueLengths());
    }

    private static Option toCfOtherOption(OtherOption otherOption, OptionDefinition definition, TransformationService transformationService) throws InternalInvalidOptionValueException {
        Option option;
        try {
            option = new Option(definition, MessageUtils.toBytes(otherOption.getValue(), transformationService));
        }
        catch (Exception e) {
            throw new InternalInvalidOptionValueException(otherOption.getAlias(), VALUE_INVALID, e);
        }
        return option;
    }

    public static OptionFormat toOptionFormat(OptionNumberRegistry.OptionFormat format) {
        switch (format) {
            case EMPTY: {
                return OptionFormat.EMPTY;
            }
            case INTEGER: {
                return OptionFormat.INTEGER;
            }
            case STRING: {
                return OptionFormat.STRING;
            }
        }
        return OptionFormat.OPAQUE;
    }

    public static byte[] toBytes(Object toConvert, TransformationService transformationService) {
        Object object = TypedValue.unwrap((Object)toConvert);
        if (object == null) {
            return Bytes.EMPTY;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Byte[]) {
            return MessageUtils.toPrimitives((Byte[])object);
        }
        if (object instanceof String) {
            return ((String)object).getBytes(CoAP.UTF8_CHARSET);
        }
        if (object instanceof BytesValue) {
            return ((BytesValue)object).getValue();
        }
        if (object instanceof Integer) {
            return OptionUtils.toBytes((Integer)object);
        }
        if (object instanceof Long) {
            return OptionUtils.toBytes((Long)object);
        }
        TypedValue value = TypedValue.of((Object)toConvert);
        return (byte[])transformationService.transform(value.getValue(), value.getDataType(), DataType.BYTE_ARRAY);
    }

    private static DefaultEntityTag toETag(EntityTag etag, TransformationService transformationService) throws OptionValueException {
        return MessageUtils.toETag(etag.getValue(), transformationService);
    }

    private static DefaultEntityTag toETag(TypedValue<Object> etagValue, TransformationService transformationService) throws OptionValueException {
        Object object = TypedValue.unwrap(etagValue);
        if (object == null) {
            throw new OptionValueException("Cannot construct etag value of object { null }");
        }
        Optional<DefaultEntityTag> optionalEtag = MessageUtils.convertETag(object);
        if (optionalEtag.isPresent()) {
            return optionalEtag.get();
        }
        return MessageUtils.transformETag(etagValue, transformationService);
    }

    private static Optional<DefaultEntityTag> toOptionalETag(TypedValue<Object> etagValue, TransformationService transformationService) throws OptionValueException {
        Object object = TypedValue.unwrap(etagValue);
        if (object == null) {
            return Optional.empty();
        }
        Optional<DefaultEntityTag> optionalEtag = MessageUtils.convertETag(object);
        if (optionalEtag.isPresent()) {
            return optionalEtag;
        }
        return Optional.of(MessageUtils.transformETag(etagValue, transformationService));
    }

    private static Optional<DefaultEntityTag> convertETag(Object object) throws OptionValueException {
        if (object instanceof DefaultEntityTag) {
            return Optional.of((DefaultEntityTag)object);
        }
        if (object instanceof DefaultBytesValue) {
            return Optional.of(new DefaultEntityTag((DefaultBytesValue)object));
        }
        if (object instanceof BytesValue) {
            return Optional.of(new DefaultEntityTag(((BytesValue)object).getValue()));
        }
        if (object instanceof Integer) {
            return Optional.of(new DefaultEntityTag((Integer)object));
        }
        if (object instanceof Long) {
            return Optional.of(new DefaultEntityTag((Long)object));
        }
        if (object instanceof String) {
            return Optional.of(new DefaultEntityTag((String)object));
        }
        if (object instanceof byte[]) {
            return Optional.of(new DefaultEntityTag((byte[])object));
        }
        if (object instanceof Byte[]) {
            return Optional.of(new DefaultEntityTag(MessageUtils.toPrimitives((Byte[])object)));
        }
        return Optional.empty();
    }

    private static DefaultEntityTag transformETag(TypedValue<Object> etagValue, TransformationService transformationService) throws OptionValueException {
        return new DefaultEntityTag((byte[])transformationService.transform(etagValue.getValue(), etagValue.getDataType(), DataType.BYTE_ARRAY));
    }

    private static List<DefaultEntityTag> toEtagList(List<EntityTag> etagValues, TransformationService transformationService) throws OptionValueException {
        LinkedList<DefaultEntityTag> list = new LinkedList<DefaultEntityTag>();
        if (etagValues != null) {
            for (EntityTag etag : etagValues) {
                list.add(MessageUtils.toETag(etag, transformationService));
            }
        }
        return Collections.unmodifiableList(list);
    }

    private static byte[] toPrimitives(Byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return OptionUtils.EMPTY_BYTES;
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    public static String queryString(List<? extends AbstractQueryParam> defaultQueryParams, List<? extends AbstractQueryParam> queryParams) {
        if ((defaultQueryParams == null || defaultQueryParams.isEmpty()) && (queryParams == null || queryParams.isEmpty())) {
            return null;
        }
        StringWriter writer = new StringWriter();
        boolean first = true;
        for (AbstractQueryParam abstractQueryParam : defaultQueryParams) {
            if (first) {
                first = false;
            } else {
                writer.append("&");
            }
            writer.append(abstractQueryParam.toString());
        }
        for (AbstractQueryParam abstractQueryParam : queryParams) {
            if (first) {
                first = false;
            } else {
                writer.append("&");
            }
            writer.append(abstractQueryParam.toString());
        }
        return writer.toString();
    }

    public static String uriString(List<String> path, List<? extends AbstractQueryParam> query) {
        if ((path == null || path.isEmpty()) && (query == null || query.isEmpty())) {
            return null;
        }
        StringWriter writer = new StringWriter();
        boolean first = true;
        writer.append("/");
        if (path != null) {
            for (String string : path) {
                if (first) {
                    first = false;
                } else {
                    writer.append("/");
                }
                writer.append(string);
            }
        }
        first = true;
        if (query != null) {
            for (AbstractQueryParam abstractQueryParam : query) {
                if (first) {
                    writer.append("?");
                    first = false;
                } else {
                    writer.append("&");
                }
                writer.append(abstractQueryParam.toString());
            }
        }
        return writer.toString();
    }

    public static Optional<List<DefaultEntityTag>> getList(List<byte[]> bytesList) throws OptionValueException {
        LinkedList<DefaultEntityTag> result = new LinkedList<DefaultEntityTag>();
        for (byte[] bytes : bytesList) {
            if (bytes.length <= 0) {
                return Optional.empty();
            }
            result.add(new DefaultEntityTag(bytes));
        }
        return Optional.of(result);
    }

    public static boolean isIn(DefaultEntityTag etag, Collection<DefaultEntityTag> etags) {
        if (etags == null) {
            return false;
        }
        return etags.contains(etag);
    }
}

