/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public final class DiscoveredResource
implements Comparable<DiscoveredResource>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final boolean obs;
    private String title;
    private LinkedList<String> ifdesc = new LinkedList();
    private LinkedList<String> rt = new LinkedList();
    private String sz;
    private LinkedList<String> ct = new LinkedList();
    private final transient AtomicInteger hashCode = new AtomicInteger();
    public static final Comparator<List<String>> LISTCOMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1.size() != o2.size()) {
            return o1.size() < o2.size() ? -1 : 1;
        }
        Iterator it1 = o1.iterator();
        Iterator it2 = o2.iterator();
        int result = 0;
        while (result == 0 && it1.hasNext() && it2.hasNext()) {
            result = Objects.compare(it1.next(), it2.next(), Comparator.nullsLast(Comparator.naturalOrder()));
        }
        return result;
    };
    public static final Comparator<DiscoveredResource> COMPARATOR = Comparator.comparing(DiscoveredResource::getPath, Comparator.naturalOrder()).thenComparing(DiscoveredResource::getObs, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DiscoveredResource::getTitle, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DiscoveredResource::getIf, LISTCOMPARATOR).thenComparing(DiscoveredResource::getRt, LISTCOMPARATOR).thenComparing(DiscoveredResource::getSz, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(DiscoveredResource::getCt, LISTCOMPARATOR);

    public DiscoveredResource(String path, boolean obs, String title, List<String> ifdesc, List<String> rt, String sz, List<String> ct) {
        if (path == null) {
            throw new NullPointerException("DiscoveredResource uri-path of null is not allowed");
        }
        this.path = path;
        this.obs = obs;
        this.title = title;
        this.ifdesc.addAll(ifdesc);
        this.rt.addAll(rt);
        this.sz = sz;
        this.ct.addAll(ct);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isObs() {
        return this.obs;
    }

    public Boolean getObs() {
        return this.obs;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getIf() {
        return Collections.unmodifiableList(this.ifdesc);
    }

    public List<String> getRt() {
        return Collections.unmodifiableList(this.rt);
    }

    public String getSz() {
        return this.sz;
    }

    public List<String> getCt() {
        return Collections.unmodifiableList(this.ct);
    }

    @Override
    public int compareTo(DiscoveredResource other) {
        if (other == null) {
            return 1;
        }
        return COMPARATOR.compare(this, other);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DiscoveredResource)) {
            return false;
        }
        return 0 == COMPARATOR.compare(this, (DiscoveredResource)other);
    }

    protected int calculateHashCode() {
        int result = 113;
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.obs);
        result = 31 * result + Objects.hashCode(this.title);
        for (String value : this.ifdesc) {
            result = 31 * result + Objects.hashCode(value);
        }
        for (String value : this.rt) {
            result = 31 * result + Objects.hashCode(value);
        }
        result = 31 * result + Objects.hashCode(this.sz);
        for (String value : this.ct) {
            result = 31 * result + Objects.hashCode(value);
        }
        return result == 0 ? 1 : result;
    }

    public int hashCode() {
        if (this.hashCode.get() == 0) {
            this.hashCode.compareAndSet(0, this.calculateHashCode());
        }
        return this.hashCode.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CoRE info {");
        builder.append(" path= ");
        builder.append(this.getPath());
        builder.append(", obs= ");
        builder.append(this.isObs());
        builder.append(", title= ");
        builder.append(this.getTitle());
        builder.append(", if= ");
        builder.append(this.getIf());
        builder.append(", rt= ");
        builder.append(this.getRt());
        builder.append(", sz= ");
        builder.append(this.getSz());
        builder.append(", ct= ");
        builder.append(this.getCt());
        builder.append(" }");
        return builder.toString();
    }
}

