/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import nl.teslanet.mule.connectors.coap.api.config.congestion.CongestionControl;
import nl.teslanet.mule.connectors.coap.api.config.deduplication.Deduplicator;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.GroupedMidTracker;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.MidTracker;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ExchangeParams
implements VisitableConfig {
    @Parameter
    @Optional(defaultValue="150000")
    @Summary(value="The maximum number of active peers supported.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxActivePeers = null;
    @Parameter
    @Optional(defaultValue="10m")
    @Summary(value="The maximum number time a peer may be inactive for before it is considered stale\n and all state associated with it can be discarded.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxPeerInactivityPeriod = null;
    @Parameter
    @Optional(defaultValue="2s")
    @Summary(value="The minimum spacing time before retransmission is tried.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String ackTimeout = null;
    @Parameter
    @Optional(defaultValue="1.5")
    @Summary(value="Factor for spreading retransmission timing.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Float ackRandomFactor = null;
    @Parameter
    @Optional(defaultValue="2.0")
    @Summary(value="The back-off factor for retransmissions. \nEvery subsequent retransmission time, spacing is enlarged using this factor.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Float ackTimeoutScale = null;
    @Parameter
    @Optional(defaultValue="4")
    @Summary(value="The maximum number of retransmissions that are attempted \nwhen no acknowledgement is received.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxRetransmit = null;
    @Parameter
    @Optional(defaultValue="1m")
    @Summary(value="Maximum CoAP acknowledge timeout for CON messages.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxAckTimeout = null;
    @Parameter
    @Optional(defaultValue="247s")
    @Summary(value="The duration between starting to send a Confirmable message \nto the moment when an acknowledgement is no longer expected.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String exchangeLifetime = null;
    @Parameter
    @Optional(defaultValue="145s")
    @Summary(value="The duration from sending a Non-confirmable message to the moment when its Message ID can be safely reused.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String nonLifetime = null;
    @Parameter
    @Optional(defaultValue="100s")
    @Summary(value="The maximum duration a datagram is expected to take from the start \n of its transmission to the completion of its reception.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxLatency = null;
    @Parameter
    @Optional(defaultValue="93s")
    @Summary(value="The maximum duration from the first transmission of \na Confirmable message to the time when the sender gives up on \nreceiving an acknowledgement or reset.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxTransmitWait = null;
    @Parameter
    @Optional(defaultValue="250s")
    @Summary(value="The expected maximum response delay over all servers \nthat the client can send a multicast request to.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxResponseDelay = null;
    @Parameter
    @Optional(defaultValue="1")
    @Summary(value="Maximum number of simultaneous outstanding interactions with a peer. \n(rfc7252 specifies default=1)")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer nstart = null;
    @Parameter
    @Optional(defaultValue="8")
    @Summary(value="The maximum token length [bytes].")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer tokenSizeLimit = null;
    @Parameter
    @Optional(defaultValue="65000")
    @Summary(value="Base for multicast MID range. Multicast requests use MIDs in the range [base...65536).\nA negative or zero value disables multicast requests.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer multicastMidBase = null;
    @Parameter
    @Optional(defaultValue="5s")
    @Summary(value="The spreading time of responses to a multicast request, \nfor network congestion prevention.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String leisure = null;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="When enabled empty messages that contain token, options or payload are considered a format error.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean strictEmptyMessageFormat = true;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="When true the message IDs will start at a random index. Otherwise the first message ID returned will be 0.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean useRandomMidStart = true;
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=GroupedMidTracker.class)
    @Summary(value="The message identity tracker strategy to use.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public MidTracker midTracker = null;
    @Parameter
    @Optional
    @Summary(value=" The deduplicator type used to deduplicate incoming messages.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Deduplicator deduplicator = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public CongestionControl congestionControl = null;

    public ExchangeParams() {
    }

    public ExchangeParams(MidTracker midTracker) {
        this.midTracker = midTracker;
    }

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
        this.midTracker.accept(visitor);
        if (this.deduplicator != null) {
            this.deduplicator.accept(visitor);
        }
        if (this.congestionControl != null) {
            this.congestionControl.accept(visitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExchangeParams rhs = (ExchangeParams)obj;
        return new EqualsBuilder().append((Object)this.ackRandomFactor, (Object)rhs.ackRandomFactor).append((Object)this.ackTimeout, (Object)rhs.ackTimeout).append((Object)this.ackTimeoutScale, (Object)rhs.ackTimeoutScale).append((Object)this.congestionControl, (Object)rhs.congestionControl).append((Object)this.deduplicator, (Object)rhs.deduplicator).append((Object)this.exchangeLifetime, (Object)rhs.exchangeLifetime).append((Object)this.leisure, (Object)rhs.leisure).append((Object)this.maxAckTimeout, (Object)rhs.maxAckTimeout).append((Object)this.maxActivePeers, (Object)rhs.maxActivePeers).append((Object)this.maxLatency, (Object)rhs.maxLatency).append((Object)this.maxPeerInactivityPeriod, (Object)rhs.maxPeerInactivityPeriod).append((Object)this.maxResponseDelay, (Object)rhs.maxResponseDelay).append((Object)this.maxRetransmit, (Object)rhs.maxRetransmit).append((Object)this.maxTransmitWait, (Object)rhs.maxTransmitWait).append((Object)this.midTracker, (Object)rhs.midTracker).append((Object)this.multicastMidBase, (Object)rhs.multicastMidBase).append((Object)this.nonLifetime, (Object)rhs.nonLifetime).append((Object)this.nstart, (Object)rhs.nstart).append(this.strictEmptyMessageFormat, rhs.strictEmptyMessageFormat).append((Object)this.tokenSizeLimit, (Object)rhs.tokenSizeLimit).append(this.useRandomMidStart, rhs.useRandomMidStart).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(21, 41).append((Object)this.ackRandomFactor).append((Object)this.ackTimeout).append((Object)this.ackTimeoutScale).append((Object)this.congestionControl).append((Object)this.deduplicator).append((Object)this.exchangeLifetime).append((Object)this.leisure).append((Object)this.maxAckTimeout).append((Object)this.maxActivePeers).append((Object)this.maxLatency).append((Object)this.maxPeerInactivityPeriod).append((Object)this.maxResponseDelay).append((Object)this.maxRetransmit).append((Object)this.maxTransmitWait).append((Object)this.midTracker).append((Object)this.multicastMidBase).append((Object)this.nonLifetime).append((Object)this.nstart).append(this.strictEmptyMessageFormat).append((Object)this.tokenSizeLimit).append(this.useRandomMidStart).toHashCode();
    }
}

