/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.dtls;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.TriState;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class DtlsMessageParams
implements VisitableConfig {
    @Parameter
    @Optional
    @Summary(value="DTLS record size limit (RFC 8449) [BYTES]. The value must be between 64 and 16K.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer recordSizeLimit = null;
    @Parameter
    @Optional
    @Summary(value="Maximum fragment length (RFC 6066).")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public FragmentSize maxFragmentLength = null;
    @Parameter
    @Optional(defaultValue="8192")
    @Summary(value="Maximum length [BYTES] of reassembled fragmented handshake message.\nMust be large enough for used certificates.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxFragmentedHandshakeMsgLength = 8192;
    @Parameter
    @Optional(defaultValue="UNDEFINED")
    @Summary(value="Use multiple DTLS records in UDP messages.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public TriState multiRecords = TriState.UNDEFINED;
    @Parameter
    @Optional(defaultValue="UNDEFINED")
    @Summary(value="Use multiple handshake messages in DTLS records.\nNot all libraries may have implemented this.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public TriState multiHandshakeMsgRecords = TriState.UNDEFINED;
    @Parameter
    @Optional
    @Summary(value="MTU (Maximum Transmission Unit) [BYTES].\nMust be used, if the MTU of the local network doesn't apply, e.g. if ip-tunnels are used.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer mtu = null;
    @Parameter
    @Optional(defaultValue="1500")
    @Summary(value="MTU (Maximum Transmission Unit) limit [BYTES] for local auto detection.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer mtuLimit = 1500;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DtlsMessageParams rhs = (DtlsMessageParams)obj;
        return new EqualsBuilder().append((Object)this.recordSizeLimit, (Object)rhs.recordSizeLimit).append((Object)this.maxFragmentLength, (Object)rhs.maxFragmentLength).append((Object)this.maxFragmentedHandshakeMsgLength, (Object)rhs.maxFragmentedHandshakeMsgLength).append((Object)this.multiRecords, (Object)rhs.multiRecords).append((Object)this.multiHandshakeMsgRecords, (Object)rhs.multiHandshakeMsgRecords).append((Object)this.mtu, (Object)rhs.mtu).append((Object)this.mtuLimit, (Object)rhs.mtuLimit).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.recordSizeLimit).append((Object)this.maxFragmentLength).append((Object)this.maxFragmentedHandshakeMsgLength).append((Object)this.multiRecords).append((Object)this.multiHandshakeMsgRecords).append((Object)this.mtu).append((Object)this.mtuLimit).toHashCode();
    }

    public static enum FragmentSize {
        BYTES_512,
        BYTES_1024,
        BYTES_2048,
        BYTES_4096;

    }
}

