/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.dtls;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class DtlsParams
implements VisitableConfig {
    @Parameter
    @Optional(defaultValue="150000")
    @Summary(value="The maximum number of active connections.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxConnections = null;
    @Parameter
    @Optional(defaultValue="30m")
    @Summary(value="Stale connections (no messages are exchanged within the threshold)\n can get removed for new connections.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String staleConnectionThreshold = null;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Update the ip-address from DTLS 1.2 CID records only for newer records\nbased on epoch/sequence_number.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean updateAddressOnNewerCidRecords = true;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Remove stale connections, if the principal has also a newer connection. \nRequires to have unique principals.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean removeStaleDoublePrincipals = false;
    @Parameter
    @Optional(defaultValue="50000")
    @Summary(value="Maximum number of jobs for outbound messages.\nThe value must be 64 or larger.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer outboundMsgCapacity = null;
    @Parameter
    @Optional(defaultValue="50000")
    @Summary(value="Maximum number of jobs for inbound messages.\nThe value must be 64 or larger.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer inboundMsgCapacity = null;
    @Parameter
    @Optional
    @Summary(value="The number of receiver threads. \nDefault value is 2 if number of CORES > 3, otherwise 1.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer dtlsReceiverThreadCount = null;
    @Parameter
    @Optional
    @Summary(value="The number of connector threads. \nThese threads handle most cryptographic \nfunctions for both incoming and outgoing messages. \nDefault value is the number of CORES.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer dtlsConnectorThreadCount = null;
    @Parameter
    @Optional(defaultValue="5000")
    @Summary(value="Maximum number of jobs for handshake results.\nThe value must be 64 or larger.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer handshakeCapacity = null;
    @Parameter
    @Optional(defaultValue="8192")
    @Summary(value="The size [Bytes] of the buffer for Handshake records with future handshake message sequence number \nor records with future epochs.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer handshakeRecordBufferSize = null;
    @Parameter
    @Optional(defaultValue="10")
    @Summary(value="The maximum number of messages sent during a handshake that are processed deferred after the handshake.\nAbove this number messages are dropped.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer deferredMsgCapacity = null;
    @Parameter
    @Optional
    @Summary(value="The period after which, without exchanged messages, \nnew messages will initiate a handshake. Clients use {@code 30[s]} as \na common value to compensate assumed NAT timeouts. Not used by servers.\nDefault no auto handshake is initiated")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String autoHandshakeTimeout = null;
    @Parameter
    @Optional(defaultValue="30")
    @Summary(value="The threshold defines the maximum percentage of handshakes without HELLO_VERIFY_REQUEST.\nWhen 0 peers are verified on all resumptions.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer verifyPeersOnResumptionThreshold = null;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Use anti replay filter.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean useAntiReplayFilter = true;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Use anti replay filter.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean useExtendedAntiReplayFilterWindow = false;
    @Parameter
    @Optional
    @Summary(value="Limit the anti replay filter window extension to given number of postponed records.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer antiReplayFilterWindowExtension = null;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DtlsParams rhs = (DtlsParams)obj;
        return new EqualsBuilder().append((Object)this.maxConnections, (Object)rhs.maxConnections).append((Object)this.staleConnectionThreshold, (Object)rhs.staleConnectionThreshold).append(this.updateAddressOnNewerCidRecords, rhs.updateAddressOnNewerCidRecords).append(this.removeStaleDoublePrincipals, rhs.removeStaleDoublePrincipals).append((Object)this.outboundMsgCapacity, (Object)rhs.outboundMsgCapacity).append((Object)this.inboundMsgCapacity, (Object)rhs.inboundMsgCapacity).append((Object)this.dtlsReceiverThreadCount, (Object)rhs.dtlsReceiverThreadCount).append((Object)this.dtlsConnectorThreadCount, (Object)rhs.dtlsConnectorThreadCount).append((Object)this.handshakeCapacity, (Object)rhs.handshakeCapacity).append((Object)this.handshakeRecordBufferSize, (Object)rhs.handshakeRecordBufferSize).append((Object)this.deferredMsgCapacity, (Object)rhs.deferredMsgCapacity).append((Object)this.autoHandshakeTimeout, (Object)rhs.autoHandshakeTimeout).append((Object)this.verifyPeersOnResumptionThreshold, (Object)rhs.verifyPeersOnResumptionThreshold).append(this.useAntiReplayFilter, rhs.useAntiReplayFilter).append(this.useExtendedAntiReplayFilterWindow, rhs.useExtendedAntiReplayFilterWindow).append((Object)this.antiReplayFilterWindowExtension, (Object)rhs.antiReplayFilterWindowExtension).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.maxConnections).append((Object)this.staleConnectionThreshold).append(this.updateAddressOnNewerCidRecords).append(this.removeStaleDoublePrincipals).append((Object)this.outboundMsgCapacity).append((Object)this.inboundMsgCapacity).append((Object)this.dtlsReceiverThreadCount).append((Object)this.dtlsConnectorThreadCount).append((Object)this.handshakeCapacity).append((Object)this.handshakeRecordBufferSize).append((Object)this.deferredMsgCapacity).append((Object)this.autoHandshakeTimeout).append((Object)this.verifyPeersOnResumptionThreshold).append(this.useAntiReplayFilter).append(this.useExtendedAntiReplayFilterWindow).append((Object)this.antiReplayFilterWindowExtension).toHashCode();
    }
}

