/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.dtls;

import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class DtlsRetransmissionParams
implements VisitableConfig {
    @Parameter
    @Optional(defaultValue="2s")
    @Summary(value="The initial DTLS retransmission timeout.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String initialTimeout = null;
    @Parameter
    @Optional(defaultValue="60s")
    @Summary(value="The maximum DTLS retransmission timeout.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String maxTimeout = null;
    @Parameter
    @Optional(defaultValue="1.0")
    @Summary(value="DTLS random factor for initial retransmission timeout.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Float timeoutRandomFactor = null;
    @Parameter
    @Optional(defaultValue="2.0")
    @Summary(value="DTLS scale factor for retransmission backoff-timeout.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Float timeoutScaleFactor;
    @Parameter
    @Optional(defaultValue="0ms")
    @Summary(value="DTLS additional initial timeout for ECC related flights.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public String additionalEccTimeout = null;
    @Parameter
    @Optional(defaultValue="4")
    @Summary(value="DTLS maximum number of flight retransmissions.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer maxRetransmissions = null;
    @Parameter
    @Optional
    @Summary(value="Number of flight-retransmissions before switching to backoff mode using single handshake messages in single record datagrams.\nSet value to 0 to disable. Default value is max retransmissions / 2.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public Integer backoffThreshold = null;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Stop retransmission on receiving the first message of the next flight, not waiting for the last message.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean earlyStop = true;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DtlsRetransmissionParams rhs = (DtlsRetransmissionParams)obj;
        return new EqualsBuilder().append((Object)this.initialTimeout, (Object)rhs.initialTimeout).append((Object)this.maxTimeout, (Object)rhs.maxTimeout).append((Object)this.timeoutRandomFactor, (Object)rhs.timeoutRandomFactor).append((Object)this.timeoutScaleFactor, (Object)rhs.timeoutScaleFactor).append((Object)this.additionalEccTimeout, (Object)rhs.additionalEccTimeout).append((Object)this.maxRetransmissions, (Object)rhs.maxRetransmissions).append((Object)this.backoffThreshold, (Object)rhs.backoffThreshold).append(this.earlyStop, rhs.earlyStop).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.initialTimeout).append((Object)this.maxTimeout).append((Object)this.timeoutRandomFactor).append((Object)this.timeoutScaleFactor).append((Object)this.additionalEccTimeout).append((Object)this.maxRetransmissions).append((Object)this.backoffThreshold).append(this.earlyStop).toHashCode();
    }
}

