/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.security;

import java.util.Objects;
import nl.teslanet.mule.connectors.coap.api.config.security.KeyConfig;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class PreSharedKey {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The identity of the key.")
    private String identity = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The hostname of the peer that uses the key. \nNeeded for (client) endpoints that connect to multiple servers.")
    private String host = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The virtual host to use the key for.")
    private String virtualHost = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The port of the peer that uses the key. \nNeeded for  (client) endpoints that connect to multiple servers.")
    private Integer port = null;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The key configuration.")
    private KeyConfig key = null;

    public PreSharedKey() {
        this.identity = null;
        this.key = null;
    }

    public PreSharedKey(String identity, KeyConfig key) {
        this(identity, key, null, null);
    }

    public PreSharedKey(String identity, KeyConfig key, String host, Integer port) {
        Validate.notEmpty((CharSequence)identity);
        Objects.requireNonNull(key);
        this.host = host;
        this.port = port;
        this.identity = identity;
        this.key = key;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getIdentity() {
        return this.identity;
    }

    public KeyConfig getKey() {
        return this.key;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.host).append((Object)this.port).append((Object)this.identity).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PreSharedKey)) {
            return false;
        }
        PreSharedKey other = (PreSharedKey)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return this.identity == ((PreSharedKey)obj).identity;
    }
}

