/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.security;

import nl.teslanet.mule.connectors.coap.api.config.security.HashAlgorithmName;
import nl.teslanet.mule.connectors.coap.api.config.security.SignatureAlgorithmName;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SignatureAlgorithm {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The signature algorithm to use.")
    public SignatureAlgorithmName algorithm = null;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The hash algorithm to use.")
    public HashAlgorithmName hashAlgorithm = null;

    public SignatureAlgorithm() {
    }

    public SignatureAlgorithm(HashAlgorithmName hashAlgorithm, SignatureAlgorithmName algorithm) {
        this.hashAlgorithm = hashAlgorithm;
        this.algorithm = algorithm;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.hashAlgorithm == null ? String.valueOf((Object)this.hashAlgorithm) : this.hashAlgorithm.name());
        builder.append("with");
        builder.append(this.algorithm == null ? String.valueOf((Object)this.algorithm) : this.algorithm.name());
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SignatureAlgorithm rhs = (SignatureAlgorithm)obj;
        return new EqualsBuilder().append((Object)this.algorithm, (Object)rhs.algorithm).append((Object)this.hashAlgorithm, (Object)rhs.hashAlgorithm).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.algorithm).append((Object)this.hashAlgorithm).toHashCode();
    }
}

