/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.teslanet.mule.connectors.coap.api.config.options.OtherOptionConfig;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Configuration(name="global-config")
public class GlobalConfig
implements Initialisable,
Disposable {
    private static final ConcurrentHashMap<String, OptionDefinition> optionDefinitions = new ConcurrentHashMap();
    @Parameter
    @Summary(value="The other option definitions. A definition is referenced by its alias")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowInlineDefinition=true, allowReferences=false)
    private List<OtherOptionConfig> otherOptionConfigs = new CopyOnWriteArrayList<OtherOptionConfig>();

    public static Optional<OptionDefinition> getOtherOptionDefinition(String alias) {
        if (alias == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(optionDefinitions.get(alias));
    }

    public GlobalConfig() {
    }

    public GlobalConfig(List<OtherOptionConfig> otherOptionConfigs) {
        this.otherOptionConfigs = otherOptionConfigs;
    }

    public void initialise() throws InitialisationException {
        this.otherOptionConfigs.forEach(otherOptionConfig -> optionDefinitions.put(otherOptionConfig.getAlias(), MessageUtils.toCfOptionDefinition(otherOptionConfig)));
    }

    public void dispose() {
        optionDefinitions.clear();
    }
}

