/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.attributes;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import nl.teslanet.mule.connectors.coap.api.options.OptionFormat;
import nl.teslanet.mule.connectors.coap.api.options.OptionUtils;
import nl.teslanet.mule.connectors.coap.api.options.OtherOptionAttribute;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.OptionDefinition;

public final class CoapOtherOptionAttributeImpl
extends OtherOptionAttribute {
    private static final String FORMAT_WRONG_TYPE = "Option{ %s } is not of type %s.";
    private final Option option;

    public CoapOtherOptionAttributeImpl(OptionDefinition optionDef, byte[] value) {
        this.option = optionDef.create(value);
    }

    public CoapOtherOptionAttributeImpl(Option option) {
        this.option = option;
    }

    @Override
    public String getAlias() {
        return this.option.getDefinition().getName();
    }

    @Override
    public int getNumber() {
        return this.option.getDefinition().getNumber();
    }

    @Override
    public OptionFormat getFormat() {
        return MessageUtils.toOptionFormat(this.option.getDefinition().getFormat());
    }

    @Override
    public boolean isEmpty() {
        return this.option.getLength() == 0;
    }

    @Override
    public int getLength() {
        return this.option.getLength();
    }

    protected byte[] getValueAsBytes() {
        return this.option.getValue();
    }

    @Override
    public InputStream getValue() {
        return OptionUtils.toInputStream(this.getValueAsBytes());
    }

    @Override
    public long getValueAsNumber() {
        if (this.option.getDefinition().getFormat() != OptionNumberRegistry.OptionFormat.INTEGER) {
            throw new NumberFormatException(String.format(FORMAT_WRONG_TYPE, this.option.getDefinition().getName(), OptionFormat.INTEGER.toString()));
        }
        return OptionUtils.toLong(this.option.getValue());
    }

    @Override
    public String getValueAsHex() {
        return OptionUtils.toHexString(this.option.getValue());
    }

    @Override
    public String getValueAsString() {
        if (this.option.getDefinition().getFormat() != OptionNumberRegistry.OptionFormat.STRING) {
            throw new NumberFormatException(String.format(FORMAT_WRONG_TYPE, this.option.getDefinition().getName(), OptionFormat.STRING.toString()));
        }
        return this.option.getStringValue();
    }

    @Override
    public boolean isCritical() {
        return OptionUtils.isCritical(this.getNumber());
    }

    @Override
    public boolean isUnsafe() {
        return OptionUtils.isUnsafe(this.getNumber());
    }

    @Override
    public boolean isNoCacheKey() {
        return OptionUtils.isNoCacheKey(this.getNumber());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.getNumber());
        result = 31 * result + Arrays.hashCode(this.getValueAsBytes());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CoapOtherOptionAttributeImpl)) {
            return false;
        }
        CoapOtherOptionAttributeImpl other = (CoapOtherOptionAttributeImpl)obj;
        return this.getNumber() == other.getNumber() && Arrays.equals(this.getValueAsBytes(), other.getValueAsBytes());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Option{");
        builder.append(" alias=").append(this.getAlias());
        builder.append(", number=").append(this.getNumber());
        switch (this.option.getDefinition().getFormat()) {
            case EMPTY: {
                builder.append(", empty");
                break;
            }
            case INTEGER: {
                builder.append(", valueAsNumber=").append(this.option.getLongValue());
                break;
            }
            case STRING: {
                builder.append(", valueAsString=").append(this.option.getStringValue());
                break;
            }
            default: {
                builder.append(", valueAsHex=").append(OptionUtils.toHexString(this.option.getValue()));
            }
        }
        builder.append(" }");
        return builder.toString();
    }
}

