/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.attributes;

import java.net.URI;
import java.net.URISyntaxException;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsAttributes;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributesStringBuilder;

public class CoapRequestAttributesImpl
extends CoapRequestAttributes {
    private URI requestUriObject = null;

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRequestOptions(RequestOptionsAttributes requestOptionAttributes) {
        this.requestOptions = requestOptionAttributes;
    }

    @Override
    public String getRequestScheme() {
        return this.getOrCreateRequestUri().getScheme();
    }

    @Override
    public String getRequestHost() {
        return this.getOrCreateRequestUri().getHost();
    }

    @Override
    public int getRequestPort() {
        return this.getOrCreateRequestUri().getPort();
    }

    @Override
    public String getRequestPath() {
        String path = this.getOrCreateRequestUri().getPath();
        if (path != null && !path.isEmpty()) {
            return path;
        }
        return "/";
    }

    @Override
    public String getRequestQuery() {
        String query = this.getOrCreateRequestUri().getQuery();
        if (query != null) {
            return query;
        }
        return "";
    }

    private synchronized URI getOrCreateRequestUri() {
        if (this.requestUriObject == null) {
            try {
                this.requestUriObject = new URI(this.requestUri == null ? "" : this.requestUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("cannot create URI from request uri", e);
            }
        }
        return this.requestUriObject;
    }

    public String toString() {
        AttributesStringBuilder builder = new AttributesStringBuilder(this);
        builder.append("relation", this.relation).append("localAddress", (Object)this.localAddress).append("remoteAddress", (Object)this.remoteAddress).append("requestType", (Object)this.requestType).append("requestCode", (Object)this.requestCode).append("requestOptions", (Object)this.requestOptions).append("requestUri", (Object)this.getRequestUri());
        return builder.toString();
    }
}

