/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.attributes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsAttributes;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.options.DefaultEntityTag;
import nl.teslanet.mule.connectors.coap.internal.utils.AppendableToString;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributesStringBuilder;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.californium.core.coap.OptionSet;

public class CoapRequestOptionsAttributesImpl
extends RequestOptionsAttributes
implements AppendableToString {
    static final String MSG_CANNOT_CREATE = "cannot create attribute";

    public CoapRequestOptionsAttributesImpl(OptionSet optionSet) throws InternalInvalidOptionValueException {
        if (!optionSet.getIfMatch().isEmpty()) {
            try {
                Optional<List<DefaultEntityTag>> tmpIfMatch = MessageUtils.getList(optionSet.getIfMatch());
                if (!tmpIfMatch.isPresent()) {
                    this.ifExists = true;
                } else {
                    this.ifMatch = Collections.unmodifiableList(tmpIfMatch.get());
                }
            }
            catch (OptionValueException e) {
                throw new InternalInvalidOptionValueException("IfMatch", MSG_CANNOT_CREATE, e);
            }
        }
        if (optionSet.hasUriHost()) {
            this.uriHost = optionSet.getUriHost();
        }
        if (!optionSet.getETags().isEmpty()) {
            try {
                Optional<List<DefaultEntityTag>> tmpEtags = MessageUtils.getList(optionSet.getETags());
                if (!tmpEtags.isPresent()) {
                    throw new InternalInvalidOptionValueException("Entity-Tag option with empty value is invalid", MSG_CANNOT_CREATE);
                }
                this.etags = Collections.unmodifiableList(tmpEtags.get());
            }
            catch (OptionValueException e) {
                throw new InternalInvalidOptionValueException("Entity-Tag option is invalid", MSG_CANNOT_CREATE, e);
            }
        }
        this.ifNoneMatch = optionSet.hasIfNoneMatch();
        if (optionSet.hasUriPort()) {
            this.uriPort = optionSet.getUriPort();
        }
        if (!optionSet.getUriPath().isEmpty()) {
            this.uriPath = Collections.unmodifiableList(optionSet.getUriPath());
        }
        if (optionSet.hasContentFormat()) {
            this.contentFormat = optionSet.getContentFormat();
        }
        if (!optionSet.getUriQuery().isEmpty()) {
            LinkedList queryParams = new LinkedList();
            optionSet.getUriQuery().forEach(queryParamString -> AttributeUtils.addQueryParam(queryParams, queryParamString));
            this.uriQuery = Collections.unmodifiableList(queryParams);
        }
        if (optionSet.hasAccept()) {
            this.accept = optionSet.getAccept();
        }
        if (optionSet.hasProxyUri()) {
            this.proxyUri = optionSet.getProxyUri();
        }
        if (optionSet.hasProxyScheme()) {
            this.proxyScheme = optionSet.getProxyScheme();
        }
        if (optionSet.hasSize1()) {
            this.requestSize = optionSet.getSize1();
        }
        if (optionSet.hasSize2() && optionSet.getSize2() == 0) {
            this.provideResponseSize = true;
        }
        if (optionSet.hasObserve()) {
            this.observe = optionSet.getObserve();
        }
        this.other = AttributeUtils.createOthers(optionSet.getOthers());
    }

    public String toString() {
        AttributesStringBuilder builder = new AttributesStringBuilder(this);
        this.appendTo(builder);
        return builder.toString();
    }

    @Override
    public void appendTo(ToStringStyle style, StringBuffer buffer) {
        AttributesStringBuilder builder = new AttributesStringBuilder(this, style, buffer);
        this.appendTo(builder);
    }

    public void appendTo(ToStringBuilder builder) {
        builder.append("accept", (Object)this.accept).append("contentFormat", (Object)this.contentFormat).append("etags", (Object)this.etags).append("ifExists", this.ifExists).append("ifMatch", (Object)this.ifMatch).append("ifNoneMatch", this.ifNoneMatch).append("observe", (Object)this.observe).append("other", (Object)this.other).append("provideResponseSize", this.provideResponseSize).append("proxyScheme", (Object)this.proxyScheme).append("proxyUri", (Object)this.proxyUri).append("requestSize", (Object)this.requestSize).append("uriHost", (Object)this.uriHost).append("uriPort", (Object)this.uriPort).append("uriPath", (Object)this.uriPath).append("uriQuery", (Object)this.uriQuery);
    }
}

