/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.attributes;

import java.util.Collections;
import java.util.LinkedList;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;
import nl.teslanet.mule.connectors.coap.api.options.ResponseOptionsAttributes;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.options.DefaultEntityTag;
import nl.teslanet.mule.connectors.coap.internal.utils.AppendableToString;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributesStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.californium.core.coap.OptionSet;

public class CoapResponseOptionsAttributesImpl
extends ResponseOptionsAttributes
implements AppendableToString {
    public CoapResponseOptionsAttributesImpl(OptionSet optionSet) throws InternalInvalidOptionValueException {
        String errorMsg = "cannot create attribute";
        if (!optionSet.getETags().isEmpty()) {
            try {
                this.etag = new DefaultEntityTag((byte[])optionSet.getETags().get(0));
            }
            catch (OptionValueException e) {
                throw new InternalInvalidOptionValueException("ETags", errorMsg, e);
            }
        }
        if (!optionSet.getLocationPath().isEmpty()) {
            this.locationPath = Collections.unmodifiableList(optionSet.getLocationPath());
        }
        if (optionSet.hasContentFormat()) {
            this.contentFormat = optionSet.getContentFormat();
        }
        if (optionSet.hasMaxAge()) {
            this.maxAge = optionSet.getMaxAge();
        }
        if (!optionSet.getLocationQuery().isEmpty()) {
            LinkedList queryParams = new LinkedList();
            optionSet.getLocationQuery().forEach(queryParamString -> AttributeUtils.addQueryParam(queryParams, queryParamString));
            this.locationQuery = Collections.unmodifiableList(queryParams);
        }
        if (optionSet.hasSize1()) {
            this.acceptableRequestSize = optionSet.getSize1();
        }
        if (optionSet.hasSize2()) {
            this.responseSize = optionSet.getSize2();
        }
        if (optionSet.hasObserve()) {
            this.observe = optionSet.getObserve();
        }
        this.other = AttributeUtils.createOthers(optionSet.getOthers());
    }

    public String toString() {
        AttributesStringBuilder builder = new AttributesStringBuilder(this);
        this.appendTo(builder);
        return builder.toString();
    }

    @Override
    public void appendTo(ToStringStyle style, StringBuffer buffer) {
        AttributesStringBuilder builder = new AttributesStringBuilder(this, style, buffer);
        this.appendTo(builder);
    }

    public void appendTo(ToStringBuilder builder) {
        builder.append("acceptableRequestSize", (Object)this.acceptableRequestSize).append("contentFormat", (Object)this.contentFormat).append("etag", (Object)this.etag).append("locationPath", (Object)this.locationPath).append("locationQuery", (Object)this.locationQuery).append("maxAge", (Object)this.maxAge).append("observe", (Object)this.observe).append("other", (Object)this.other).append("responseSize", (Object)this.responseSize);
    }
}

