/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import nl.teslanet.mule.connectors.coap.api.AbstractAddressParams;
import nl.teslanet.mule.connectors.coap.api.AbstractQueryParams;
import nl.teslanet.mule.connectors.coap.api.AbstractResourceParams;
import nl.teslanet.mule.connectors.coap.api.AbstractResourceRequestParams;
import nl.teslanet.mule.connectors.coap.api.CoapMessageType;
import nl.teslanet.mule.connectors.coap.api.CoapRequestCode;
import nl.teslanet.mule.connectors.coap.api.CoapRequestType;
import nl.teslanet.mule.connectors.coap.api.DiscoverParams;
import nl.teslanet.mule.connectors.coap.api.ObserverAddParams;
import nl.teslanet.mule.connectors.coap.api.ObserverExistsParams;
import nl.teslanet.mule.connectors.coap.api.ObserverRemoveParams;
import nl.teslanet.mule.connectors.coap.api.PingParams;
import nl.teslanet.mule.connectors.coap.api.Proxy;
import nl.teslanet.mule.connectors.coap.api.ProxyConfig;
import nl.teslanet.mule.connectors.coap.api.RemoteEndpoint;
import nl.teslanet.mule.connectors.coap.api.RemoteEndpointConfig;
import nl.teslanet.mule.connectors.coap.api.RequestParams;
import nl.teslanet.mule.connectors.coap.api.ResponseHandlerParams;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.UDPEndpoint;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsParams;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapResponseAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.client.ClientOperations;
import nl.teslanet.mule.connectors.coap.internal.client.CoapRequestBuilder;
import nl.teslanet.mule.connectors.coap.internal.client.ConnectorCoapClient;
import nl.teslanet.mule.connectors.coap.internal.client.ObserveRelation;
import nl.teslanet.mule.connectors.coap.internal.client.Observer;
import nl.teslanet.mule.connectors.coap.internal.client.ObserverConfig;
import nl.teslanet.mule.connectors.coap.internal.client.RequestConfig;
import nl.teslanet.mule.connectors.coap.internal.client.ResponseProcessor;
import nl.teslanet.mule.connectors.coap.internal.endpoint.OperationalEndpoint;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalClientErrorResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalEndpointException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidHandlerException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidMessageTypeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidObserverException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidResponseCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalNoResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalRequestException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalServerErrorResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnexpectedResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import nl.teslanet.mule.connectors.coap.internal.options.MediaTypeMediator;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration(name="client")
@Sources(value={Observer.class})
@Operations(value={ClientOperations.class})
public class Client
implements Initialisable,
Disposable,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Client.class.getCanonicalName());
    private static final String INVALID_URI_FORMAT = "%s cannot form valid uri { scheme= %s, host= %s, port= %d, path= %s, query= %s }";
    @RefName
    private String clientName = null;
    @Inject
    private TransformationService transformationService;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private SchedulerConfig schedulerConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false, allowInlineDefinition=true)
    @Summary(value="The endpoint the client uses.")
    @Placement(order=1, tab="Endpoint")
    private nl.teslanet.mule.connectors.coap.api.config.endpoint.Endpoint endpoint;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="When true, synchronous operations will throw an exception when CoAP error codes are received or a timeout has occurred. Otherwise a result is returned in these cases, with attribute.success set to false.")
    private boolean throwExceptionOnErrorResponse = true;
    @ParameterGroup(name="Request defaults")
    private RequestConfig requestConfig;
    private String scheme;
    private OperationalEndpoint operationalEndpoint = null;
    private ConnectorCoapClient coapClient = null;
    private ConcurrentHashMap<URI, ObserveRelation> observeRelations = new ConcurrentHashMap();
    private static UDPEndpoint defaultEndpoint = null;

    public void initialise() throws InitialisationException {
        AbstractEndpoint abstractEndpoint;
        if (this.endpoint == null) {
            abstractEndpoint = this.getDefaultEndpoint();
        } else {
            abstractEndpoint = this.endpoint.getEndpoint();
            if (abstractEndpoint == null) {
                throw new InitialisationException((Throwable)new IllegalArgumentException("Unexpected null value in client endpoint."), (Initialisable)this);
            }
        }
        if (abstractEndpoint.configName == null) {
            abstractEndpoint.configName = this.toString();
        }
        try {
            this.operationalEndpoint = OperationalEndpoint.getOrCreate(this, abstractEndpoint);
        }
        catch (EndpointConstructionException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.scheme = this.operationalEndpoint.getCoapEndpoint().getUri().getScheme();
        LOGGER.info("{} initialised.", (Object)this);
    }

    public void start() throws MuleException {
        this.coapClient = new ConnectorCoapClient();
        this.operationalEndpoint.setSchedulersIfNeeded(this.schedulerService, this.schedulerConfig);
        this.coapClient.setEndpoint((Endpoint)this.operationalEndpoint.getCoapEndpoint());
        try {
            this.operationalEndpoint.startIfNeeded();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this);
        }
        LOGGER.info("{} connected to Endpoint { {} } ", (Object)this, (Object)this.operationalEndpoint);
        LOGGER.info("{} started.", (Object)this);
    }

    public void stop() throws MuleException {
        for (ObserveRelation relation : this.observeRelations.values()) {
            relation.stop();
        }
        this.observeRelations.clear();
        this.coapClient.shutdown();
        this.coapClient = null;
        LOGGER.info("{} stopped.", (Object)this);
    }

    public void dispose() {
        OperationalEndpoint.disposeAll(this);
        this.operationalEndpoint = null;
        LOGGER.info("{} disposed.", (Object)this);
    }

    public String getClientName() {
        return this.clientName;
    }

    CoapClient getCoapClient() {
        return this.coapClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDPEndpoint getDefaultEndpoint() {
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (defaultEndpoint == null) {
                defaultEndpoint = new UDPEndpoint("default");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultEndpoint;
        }
    }

    synchronized void addRelation(URI uri, ObserveRelation relation) throws InternalInvalidObserverException, InternalUriException {
        if (uri == null) {
            throw new InternalUriException(this + " empty uri is invalid.");
        }
        if (this.observeRelations.get(uri) != null) {
            throw new InternalInvalidObserverException(String.format("%s observer already exists: { %s }", this, uri));
        }
        this.observeRelations.put(uri, relation);
    }

    ObserveRelation getRelation(URI uri) throws InternalUriException {
        if (uri == null) {
            throw new InternalUriException(this + " empty uri is invalid.");
        }
        return this.observeRelations.get(uri);
    }

    synchronized void removeRelation(URI uri) {
        this.observeRelations.remove(uri);
    }

    Map<URI, ObserveRelation> getRelations() {
        return this.observeRelations;
    }

    String getLocalAddress() {
        return this.operationalEndpoint.getCoapEndpoint().getAddress().toString();
    }

    Result<InputStream, CoapResponseAttributes> doRequest(RequestParams requestParams, RequestOptionsParams options, ResponseHandlerParams handlerBuilder) throws InternalInvalidHandlerException, InternalRequestException, InternalResponseException, InternalEndpointException, InternalInvalidRequestCodeException, InternalNoResponseException, InternalClientErrorResponseException, InternalInvalidResponseCodeException, InternalServerErrorResponseException, InternalUriException {
        Result<InputStream, CoapResponseAttributes> result = null;
        CoapHandler handler = null;
        try {
            CoapRequestBuilderImpl requestBuilder = new CoapRequestBuilderImpl(requestParams, options);
            if (handlerBuilder != null) {
                ResponseProcessor processor = ResponseProcessor.getResponseProcessor(handlerBuilder.getResponseHandler().getHandlerName());
                handler = this.createCoapHandler(handlerBuilder.getResponseHandler().getHandlerName(), requestBuilder, processor);
                this.coapClient.advanced(handler, requestBuilder.build());
            } else {
                result = this.executeSynchronous(requestBuilder);
            }
        }
        catch (InternalInvalidOptionValueException | InternalUnkownOptionException e) {
            throw new InternalRequestException(this + " cannot process request options", e);
        }
        return result;
    }

    private Result<InputStream, CoapResponseAttributes> executeSynchronous(CoapRequestBuilder requestBuilder) throws InternalEndpointException, InternalNoResponseException, InternalClientErrorResponseException, InternalInvalidResponseCodeException, InternalServerErrorResponseException, InternalResponseException, InternalInvalidRequestCodeException, InternalUriException, InternalRequestException, InternalInvalidOptionValueException, InternalUnkownOptionException {
        Result result;
        CoapResponseAttributesImpl responseAttributes;
        CoapResponse response;
        try {
            response = this.coapClient.advanced(requestBuilder.build());
        }
        catch (IOException | ConnectorException e) {
            throw new InternalEndpointException(this + " CoAP request failed", e);
        }
        this.throwExceptionWhenNeeded(this.throwExceptionOnErrorResponse, response);
        try {
            responseAttributes = ResponseProcessor.createReceivedResponseAttributes(this.getLocalAddress(), requestBuilder, response);
        }
        catch (InternalInvalidMessageTypeException | InternalInvalidOptionValueException | InternalInvalidResponseCodeException e) {
            throw new InternalResponseException(this + " CoAP response cannot be processed", e);
        }
        if (response == null) {
            result = Result.builder().output(null).attributes((Object)responseAttributes).mediaType(MediaType.ANY).build();
        } else {
            byte[] payload = response.getPayload();
            result = Result.builder().output((Object)new ByteArrayInputStream(payload)).length((long)payload.length).attributes((Object)responseAttributes).mediaType(MediaTypeMediator.toMediaType(response.getOptions().getContentFormat())).build();
        }
        return result;
    }

    private void throwExceptionWhenNeeded(CoapResponse response) throws InternalNoResponseException, InternalClientErrorResponseException, InternalInvalidResponseCodeException, InternalServerErrorResponseException, InternalResponseException {
        this.throwExceptionWhenNeeded(true, response);
    }

    private void throwExceptionWhenNeeded(boolean needed, CoapResponse response) throws InternalNoResponseException, InternalClientErrorResponseException, InternalInvalidResponseCodeException, InternalServerErrorResponseException, InternalResponseException {
        if (needed) {
            if (response == null) {
                throw new InternalNoResponseException();
            }
            if (!response.isSuccess()) {
                String message = this + " response code received: " + (Object)((Object)AttributeUtils.toResponseCodeAttribute(response.getCode()));
                if (response.getCode().isClientError()) {
                    throw new InternalClientErrorResponseException(message);
                }
                if (response.getCode().isServerError()) {
                    throw new InternalServerErrorResponseException(message);
                }
                throw new InternalResponseException(message);
            }
        }
    }

    private CoapHandler createCoapHandler(final String handlerName, final CoapRequestBuilder requestBuilder, final ResponseProcessor processor) {
        final Client thisClient = this;
        return new CoapHandler(){

            public void onError() {
                try {
                    ResponseProcessor.processMuleFlow(thisClient.getLocalAddress(), requestBuilder, null, processor);
                }
                catch (InternalResponseException e) {
                    LOGGER.error(String.format("Handler { %s::%s } cannot proces an error on asynchronous request or response.", thisClient.getClientName(), handlerName), (Throwable)e);
                }
            }

            public void onLoad(CoapResponse response) {
                try {
                    ResponseProcessor.processMuleFlow(thisClient.getLocalAddress(), requestBuilder, response, processor);
                }
                catch (InternalResponseException e) {
                    LOGGER.error(String.format("Handler { %s::%s } cannot proces an asynchronous response.", thisClient.getClientName(), handlerName), (Throwable)e);
                    try {
                        ResponseProcessor.processMuleFlow(thisClient.getLocalAddress(), requestBuilder, null, processor);
                    }
                    catch (InternalResponseException e1) {
                        LOGGER.error(String.format("Handler { %s::%s } cannot proces an error on asynchronous respons.", thisClient.getClientName(), handlerName), (Throwable)e);
                    }
                }
            }
        };
    }

    Boolean ping(PingParams pingbuilder) throws ConnectorException, IOException, InternalUriException {
        Request request;
        try {
            request = new CoapRequestBuilderImpl(pingbuilder).buildEmpty();
        }
        catch (Exception e) {
            throw new InternalUriException(e);
        }
        this.coapClient.advanced(request);
        return request.isRejected();
    }

    Set<WebLink> discover(DiscoverParams discoverParams) throws InternalUriException, InternalNoResponseException, InternalUnexpectedResponseException, ConnectorException, IOException, InternalClientErrorResponseException, InternalInvalidResponseCodeException, InternalServerErrorResponseException, InternalResponseException, InternalInvalidRequestCodeException, InternalRequestException, InternalInvalidOptionValueException, InternalUnkownOptionException {
        Request request = new CoapRequestBuilderImpl(discoverParams).build();
        CoapResponse response = this.coapClient.advanced(request);
        this.throwExceptionWhenNeeded(response);
        if (response.getOptions().getContentFormat() != 40) {
            throw new InternalUnexpectedResponseException(String.format("%s no link format received on discover request from { %s }", this, request.getURI()));
        }
        return LinkFormat.parse((String)response.getResponseText());
    }

    synchronized void addObserver(ObserverAddParams params, ResponseHandlerParams handlerBuilder) throws InternalInvalidObserverException, InternalUriException, InternalInvalidHandlerException {
        ResponseProcessor processor = ResponseProcessor.getResponseProcessor(handlerBuilder.getResponseHandler().getHandlerName());
        CoapRequestBuilderImpl requestBuilder = new CoapRequestBuilderImpl(params);
        URI uri = requestBuilder.buildResourceUri();
        String localAddress = this.getLocalAddress();
        ObserveRelation relation = this.getRelation(uri);
        if (relation != null) {
            relation.stop();
            this.removeRelation(uri);
        }
        relation = new ObserveRelation(String.format("CoAP Observer { %s::%s }", this.getClientName(), uri), this.coapClient, requestBuilder, (requestBuilder2, response) -> ResponseProcessor.processMuleFlow(localAddress, requestBuilder2, response, processor));
        this.addRelation(uri, relation);
        relation.start();
    }

    synchronized void removeObserver(ObserverRemoveParams params) throws InternalUriException, InternalInvalidObserverException {
        CoapRequestBuilderImpl requestBuilder = new CoapRequestBuilderImpl(params);
        URI uri = requestBuilder.buildResourceUri();
        ObserveRelation relation = this.getRelation(uri);
        if (relation == null) {
            throw new InternalInvalidObserverException(String.format("%s cannot stop observer, observer nonexistent on resource { %s }", this, uri));
        }
        relation.stop(requestBuilder.buildMessageType() == CoapMessageType.CONFIRMABLE);
        this.removeRelation(uri);
    }

    public boolean observerExists(ObserverExistsParams params) throws InternalUriException {
        CoapRequestBuilderImpl requestBuilder = new CoapRequestBuilderImpl(params);
        URI uri = requestBuilder.buildResourceUri();
        ObserveRelation relation = this.getRelation(uri);
        return relation != null;
    }

    public String toString() {
        return String.format("CoAP Client { %s }", this.getClientName());
    }

    class CoapRequestBuilderImpl
    implements CoapRequestBuilder {
        Boolean observe = null;
        boolean confirmable = true;
        CoapRequestCode requestCode = null;
        String proxyScheme = null;
        String endpointHost = null;
        int endpointPort = -1;
        String resourceHost = null;
        int resourcePort = -1;
        String resourcePath = null;
        String resourceQuery = null;
        boolean forcePayload = false;
        RequestOptionsParams options = null;
        OptionSet optionSet = null;
        TypedValue<Object> requestPayload = null;

        private void setPayload(Request request) throws InternalRequestException {
            if (this.requestPayload != null && this.requestPayload.getValue() != null) {
                boolean sendPayload;
                switch (request.getCode()) {
                    case GET: 
                    case DELETE: {
                        if (this.forcePayload) {
                            request.setUnintendedPayload();
                            sendPayload = true;
                            break;
                        }
                        sendPayload = false;
                        break;
                    }
                    default: {
                        sendPayload = true;
                    }
                }
                if (sendPayload) {
                    try {
                        request.setPayload(MessageUtils.toBytes(this.requestPayload, Client.this.transformationService));
                    }
                    catch (RuntimeException e) {
                        throw new InternalRequestException(Client.this + " cannot convert payload to byte[]", e);
                    }
                    if (this.optionSet.getContentFormat() == -1) {
                        this.optionSet.setContentFormat(MediaTypeMediator.toContentFormat(this.requestPayload.getDataType().getMediaType()));
                    }
                }
            }
        }

        private void setEndpointAddress(String host, Integer port) {
            this.endpointHost = host;
            if (port != null) {
                this.endpointPort = port;
            }
        }

        private void setProxyScheme(RemoteEndpointConfig remoteEndpoint) {
            ProxyConfig proxy;
            if (remoteEndpoint instanceof ProxyConfig && (proxy = (ProxyConfig)remoteEndpoint).getForwardToScheme() != null) {
                this.proxyScheme = proxy.getForwardToScheme();
            }
        }

        private void setProxyScheme(RemoteEndpoint remoteEndpoint) {
            Proxy proxy;
            if (remoteEndpoint instanceof Proxy && (proxy = (Proxy)remoteEndpoint).getForwardToScheme() != null) {
                this.proxyScheme = proxy.getForwardToScheme();
            }
        }

        public CoapRequestBuilderImpl(PingParams params) {
            if (params.getPingAddress() != null) {
                this.setEndpointAddress(params.getPingAddress().getEndpointHost(), params.getPingAddress().getEndpointPort());
            } else if (Client.this.requestConfig.getRemoteEndpointConfig() != null) {
                this.setEndpointAddress(Client.this.requestConfig.getRemoteEndpointConfig().getEndpointHost(), Client.this.requestConfig.getRemoteEndpointConfig().getEndpointPort());
            } else {
                this.setEndpointAddress(Client.this.requestConfig.getHost(), Client.this.requestConfig.getPort());
            }
        }

        public CoapRequestBuilderImpl(DiscoverParams params) {
            this((AbstractQueryParams)params);
            this.confirmable = params.getType() == CoapRequestType.CONFIRMABLE ? true : (params.getType() == CoapRequestType.NON_CONFIRMABLE ? false : this$0.requestConfig.isConfirmable());
            this.requestCode = CoapRequestCode.GET;
            this.resourcePath = "/.well-known/core";
        }

        public CoapRequestBuilderImpl(RequestParams params, RequestOptionsParams options) {
            this(params);
            this.requestCode = params.getRequestCode();
            this.forcePayload = params.isForcePayload();
            this.requestPayload = params.getRequestPayload();
            this.options = options;
        }

        private CoapRequestBuilderImpl(AbstractResourceRequestParams params) {
            this((AbstractResourceParams)params);
            this.confirmable = params.getType() == CoapRequestType.CONFIRMABLE ? true : (params.getType() == CoapRequestType.NON_CONFIRMABLE ? false : this$0.requestConfig.isConfirmable());
        }

        private CoapRequestBuilderImpl(AbstractResourceParams params) {
            this((AbstractQueryParams)params);
            if (params.getPath() != null) {
                this.resourcePath = params.getPath();
            } else if (this$0.requestConfig.getPath() != null) {
                this.resourcePath = this$0.requestConfig.getPath();
            }
        }

        private CoapRequestBuilderImpl(AbstractQueryParams params) {
            this((AbstractAddressParams)params);
            this.resourceQuery = MessageUtils.queryString(this$0.requestConfig.getQueryConfigs(), params.getQueryParams());
        }

        private CoapRequestBuilderImpl(AbstractAddressParams params) {
            if (params.getRemoteEndpoint() != null) {
                this.setEndpointAddress(params.getRemoteEndpoint().getEndpointHost(), params.getRemoteEndpoint().getEndpointPort());
            } else if (Client.this.requestConfig.getRemoteEndpointConfig() != null) {
                this.setEndpointAddress(Client.this.requestConfig.getRemoteEndpointConfig().getEndpointHost(), Client.this.requestConfig.getRemoteEndpointConfig().getEndpointPort());
            } else {
                this.endpointHost = params.getHost() != null ? params.getHost() : Client.this.requestConfig.getHost();
                if (params.getPort() != null) {
                    this.endpointPort = params.getPort();
                } else if (Client.this.requestConfig.getPort() != null) {
                    this.endpointPort = Client.this.requestConfig.getPort();
                }
            }
            if (params.getRemoteEndpoint() != null) {
                this.setProxyScheme(params.getRemoteEndpoint());
            } else if (Client.this.requestConfig.getRemoteEndpointConfig() != null) {
                this.setProxyScheme(Client.this.requestConfig.getRemoteEndpointConfig());
            }
            this.resourceHost = params.getHost() != null ? params.getHost() : Client.this.requestConfig.getHost();
            if (params.getPort() != null) {
                this.resourcePort = params.getPort();
            } else if (Client.this.requestConfig.getPort() != null) {
                this.resourcePort = Client.this.requestConfig.getPort();
            }
        }

        public CoapRequestBuilderImpl(ObserverAddParams params) {
            this((AbstractResourceRequestParams)params);
            this.observe = Boolean.TRUE;
            this.requestCode = CoapRequestCode.GET;
        }

        public CoapRequestBuilderImpl(ObserverRemoveParams params) {
            this((AbstractResourceRequestParams)params);
            this.observe = Boolean.FALSE;
            this.requestCode = CoapRequestCode.GET;
        }

        public CoapRequestBuilderImpl(ObserverConfig params) {
            this.observe = Boolean.TRUE;
            this.requestCode = CoapRequestCode.GET;
            this.confirmable = params.getType() == CoapRequestType.CONFIRMABLE ? true : (params.getType() == CoapRequestType.NON_CONFIRMABLE ? false : Client.this.requestConfig.isConfirmable());
            if (params.getRemoteEndpointConfig() != null) {
                this.setEndpointAddress(params.getRemoteEndpointConfig().getEndpointHost(), params.getRemoteEndpointConfig().getEndpointPort());
            } else if (Client.this.requestConfig.getRemoteEndpointConfig() != null) {
                this.setEndpointAddress(Client.this.requestConfig.getRemoteEndpointConfig().getEndpointHost(), Client.this.requestConfig.getRemoteEndpointConfig().getEndpointPort());
            } else {
                this.endpointHost = params.getHost() != null ? params.getHost() : Client.this.requestConfig.getHost();
                if (params.getPort() != null) {
                    this.endpointPort = params.getPort();
                } else if (Client.this.requestConfig.getPort() != null) {
                    this.endpointPort = Client.this.requestConfig.getPort();
                }
            }
            if (params.getRemoteEndpointConfig() != null) {
                this.setProxyScheme(params.getRemoteEndpointConfig());
            } else if (Client.this.requestConfig.getRemoteEndpointConfig() != null) {
                this.setProxyScheme(Client.this.requestConfig.getRemoteEndpointConfig());
            }
            this.resourceHost = params.getHost() != null ? params.getHost() : Client.this.requestConfig.getHost();
            if (params.getPort() != null) {
                this.resourcePort = params.getPort();
            } else if (Client.this.requestConfig.getPort() != null) {
                this.resourcePort = Client.this.requestConfig.getPort();
            }
            this.resourceQuery = MessageUtils.queryString(Client.this.requestConfig.getQueryConfigs(), params.getQueryConfigs());
            if (params.getPath() != null) {
                this.resourcePath = params.getPath();
            } else if (Client.this.requestConfig.getPath() != null) {
                this.resourcePath = Client.this.requestConfig.getPath();
            }
        }

        @Override
        public CoapMessageType buildMessageType() {
            if (this.confirmable) {
                return CoapMessageType.CONFIRMABLE;
            }
            return CoapMessageType.NON_CONFIRMABLE;
        }

        @Override
        public CoapRequestCode buildRequestCode() {
            return this.requestCode;
        }

        @Override
        public URI buildEndpointUri() throws InternalUriException {
            URI uri;
            try {
                uri = new URI(Client.this.scheme, null, this.endpointHost, this.endpointPort, null, null, null);
            }
            catch (Exception e) {
                throw new InternalUriException(String.format(Client.INVALID_URI_FORMAT, Client.this, Client.this.scheme, this.endpointHost, this.endpointPort, "", ""), e);
            }
            return uri;
        }

        @Override
        public URI buildResourceUri() throws InternalUriException {
            URI uri;
            if (this.resourcePath == null) {
                throw new InternalUriException(Client.this + " cannot form valid uri using path { null }");
            }
            try {
                uri = new URI(this.proxyScheme != null ? this.proxyScheme : Client.this.scheme, null, this.resourceHost, this.resourcePort, this.resourcePath, this.resourceQuery, null);
            }
            catch (Exception e) {
                throw new InternalUriException(String.format(Client.INVALID_URI_FORMAT, Client.this, Client.this.scheme, this.endpointHost, this.endpointPort, this.resourcePath, this.resourceQuery));
            }
            return uri;
        }

        @Override
        public Request buildEmpty() throws InternalUriException {
            Request request = new Request(null, this.confirmable ? CoAP.Type.CON : CoAP.Type.NON);
            request.setURI(this.buildEndpointUri());
            request.setToken(Token.EMPTY);
            return request;
        }

        @Override
        public Request build() throws InternalInvalidRequestCodeException, InternalUriException, InternalRequestException, InternalInvalidOptionValueException, InternalUnkownOptionException {
            Request request = new Request(AttributeUtils.toRequestCode(this.requestCode), this.confirmable ? CoAP.Type.CON : CoAP.Type.NON);
            this.optionSet = request.getOptions();
            if (this.options != null) {
                MessageUtils.copyOptions(this.options, this.optionSet, Client.this.transformationService);
                MessageUtils.copyOptions(this.options.getOtherOptions(), this.optionSet, Client.this.transformationService);
            }
            request.setURI(this.buildEndpointUri());
            request.setOptions(this.buildResourceUri());
            if (this.observe != null) {
                if (this.observe.booleanValue()) {
                    request.setObserve();
                } else {
                    request.setObserveCancel();
                }
            }
            if (this.proxyScheme != null) {
                request.getOptions().setProxyScheme(this.proxyScheme);
            }
            this.setPayload(request);
            return request;
        }

        @Override
        public OptionSet buildOptionSet() {
            return this.optionSet;
        }
    }
}

