/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import nl.teslanet.mule.connectors.coap.api.DiscoverParams;
import nl.teslanet.mule.connectors.coap.api.DiscoveredResource;
import nl.teslanet.mule.connectors.coap.api.ObserverAddParams;
import nl.teslanet.mule.connectors.coap.api.ObserverExistsParams;
import nl.teslanet.mule.connectors.coap.api.ObserverRemoveParams;
import nl.teslanet.mule.connectors.coap.api.PingParams;
import nl.teslanet.mule.connectors.coap.api.RequestParams;
import nl.teslanet.mule.connectors.coap.api.ResponseHandlerParams;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.api.error.ClientErrorResponseException;
import nl.teslanet.mule.connectors.coap.api.error.EndpointException;
import nl.teslanet.mule.connectors.coap.api.error.InvalidHandlerException;
import nl.teslanet.mule.connectors.coap.api.error.InvalidObserverException;
import nl.teslanet.mule.connectors.coap.api.error.InvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.api.error.NoResponseException;
import nl.teslanet.mule.connectors.coap.api.error.RequestException;
import nl.teslanet.mule.connectors.coap.api.error.ResponseException;
import nl.teslanet.mule.connectors.coap.api.error.ServerErrorResponseException;
import nl.teslanet.mule.connectors.coap.api.error.UriException;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsParams;
import nl.teslanet.mule.connectors.coap.internal.client.Client;
import nl.teslanet.mule.connectors.coap.internal.exceptions.DiscoverErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalClientErrorResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalEndpointException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidHandlerException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidObserverException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidResponseCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalNoResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalRequestException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalServerErrorResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnexpectedResponseException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.ObserverAddErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.ObserverExistsErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.ObserverRemoveErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.PingErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.RequestAsyncErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.exceptions.RequestErrorProvider;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class ClientOperations {
    static final String REQUEST_ERROR_MSG = " failed to execute request.";
    static final String ASYNC_REQUEST_ERROR_MSG = " failed to execute async request.";
    static final String PING_ERROR_MSG = " failed to execute ping.";
    static final String DISCOVERY_ERROR_MSG = " failed to execute discover.";
    static final String OBSERVER_ADD_ERROR_MSG = " failed to add observer.";
    static final String OBSERVER_REMOVE_ERROR_MSG = " failed to remove observer.";
    static final String OBSERVER_EXISTS_ERROR_MSG = " failed to query observer existence.";

    @MediaType(value="*/*", strict=false)
    @Throws(value={RequestErrorProvider.class})
    public Result<InputStream, CoapResponseAttributes> request(@Config Client client, @ParameterGroup(name="Request") RequestParams requestParams, @ParameterGroup(name="Request options") @Summary(value="The CoAP options to send with the request.") @Placement(tab="Options", order=1) RequestOptionsParams requestOptions) {
        try {
            return client.doRequest(requestParams, requestOptions, null);
        }
        catch (InternalEndpointException e) {
            throw new EndpointException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalInvalidHandlerException | InternalInvalidRequestCodeException | InternalRequestException e) {
            throw new RequestException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalInvalidResponseCodeException | InternalResponseException e) {
            throw new ResponseException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalUriException e) {
            throw new UriException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalNoResponseException e) {
            throw new NoResponseException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalClientErrorResponseException e) {
            throw new ClientErrorResponseException(client + REQUEST_ERROR_MSG, e);
        }
        catch (InternalServerErrorResponseException e) {
            throw new ServerErrorResponseException(client + REQUEST_ERROR_MSG, e);
        }
    }

    @Throws(value={RequestAsyncErrorProvider.class})
    public void requestAsync(@Config Client client, @ParameterGroup(name="Response handling") ResponseHandlerParams responseHandlerParams, @ParameterGroup(name="Request") RequestParams requestParams, @ParameterGroup(name="Request options") @Summary(value="The CoAP options to send with the request.") @Placement(tab="Options", order=1) RequestOptionsParams requestOptions) {
        try {
            client.doRequest(requestParams, requestOptions, responseHandlerParams);
        }
        catch (InternalEndpointException e) {
            throw new EndpointException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalInvalidRequestCodeException | InternalRequestException | InternalResponseException e) {
            throw new RequestException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalInvalidHandlerException e) {
            throw new InvalidHandlerException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalUriException e) {
            throw new UriException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalInvalidResponseCodeException e) {
            throw new ResponseException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalNoResponseException e) {
            throw new NoResponseException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalClientErrorResponseException e) {
            throw new ClientErrorResponseException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
        catch (InternalServerErrorResponseException e) {
            throw new ServerErrorResponseException(client + ASYNC_REQUEST_ERROR_MSG, e);
        }
    }

    @Throws(value={PingErrorProvider.class})
    public boolean ping(@Config Client client, @ParameterGroup(name="Ping address") PingParams pingParams) {
        try {
            return client.ping(pingParams);
        }
        catch (IOException | ConnectorException e) {
            throw new EndpointException(client + PING_ERROR_MSG, e);
        }
        catch (InternalUriException e) {
            throw new UriException(client + PING_ERROR_MSG, e);
        }
    }

    @Throws(value={DiscoverErrorProvider.class})
    public Set<DiscoveredResource> discover(@Config Client client, @ParameterGroup(name="Discover address") DiscoverParams discoverParams) {
        Set<WebLink> links = null;
        try {
            links = client.discover(discoverParams);
        }
        catch (IOException | ConnectorException e) {
            throw new EndpointException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalUriException e) {
            throw new UriException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalClientErrorResponseException | InternalInvalidResponseCodeException | InternalResponseException | InternalUnexpectedResponseException e) {
            throw new ResponseException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalNoResponseException e) {
            throw new NoResponseException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalServerErrorResponseException e) {
            throw new ServerErrorResponseException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalInvalidRequestCodeException e) {
            throw new InvalidRequestCodeException(client + DISCOVERY_ERROR_MSG, e);
        }
        catch (InternalInvalidOptionValueException | InternalRequestException | InternalUnkownOptionException e) {
            throw new RequestException(client + DISCOVERY_ERROR_MSG, e);
        }
        ConcurrentSkipListSet<DiscoveredResource> resultSet = new ConcurrentSkipListSet<DiscoveredResource>();
        for (WebLink link : links) {
            resultSet.add(new DiscoveredResource(link.getURI(), link.getAttributes().hasObservable(), link.getAttributes().getTitle(), link.getAttributes().getInterfaceDescriptions(), link.getAttributes().getResourceTypes(), link.getAttributes().getMaximumSizeEstimate(), link.getAttributes().getContentTypes()));
        }
        return resultSet;
    }

    @Throws(value={ObserverAddErrorProvider.class})
    public void observerAdd(@Config Client client, @ParameterGroup(name="Notification handling") ResponseHandlerParams responseHandlerParams, @ParameterGroup(name="Observe request") ObserverAddParams observerAddParams) {
        try {
            client.addObserver(observerAddParams, responseHandlerParams);
        }
        catch (InternalUriException e) {
            throw new UriException(client + OBSERVER_ADD_ERROR_MSG, e);
        }
        catch (InternalInvalidObserverException e) {
            throw new InvalidObserverException(client + OBSERVER_ADD_ERROR_MSG, e);
        }
        catch (InternalInvalidHandlerException e) {
            throw new InvalidHandlerException(client + OBSERVER_ADD_ERROR_MSG, e);
        }
    }

    @Throws(value={ObserverRemoveErrorProvider.class})
    public void observerRemove(@Config Client client, @ParameterGroup(name="Observe request") ObserverRemoveParams observerRemoveParams) {
        try {
            client.removeObserver(observerRemoveParams);
        }
        catch (InternalUriException e) {
            throw new UriException(client + OBSERVER_REMOVE_ERROR_MSG, e);
        }
        catch (InternalInvalidObserverException e) {
            throw new InvalidObserverException(client + OBSERVER_REMOVE_ERROR_MSG, e);
        }
    }

    @Throws(value={ObserverExistsErrorProvider.class})
    public boolean observerExists(@Config Client client, @ParameterGroup(name="Observer uri") ObserverExistsParams observerExistsParams) {
        try {
            return client.observerExists(observerExistsParams);
        }
        catch (InternalUriException e) {
            throw new UriException(client + OBSERVER_EXISTS_ERROR_MSG, e);
        }
    }

    public Set<String> observerList(@Config Client client) {
        return client.getRelations().keySet().stream().map(URI::toString).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
    }
}

