/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.client;

import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.ResponseHandler;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.internal.client.ResponseProcessor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidHandlerException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.StartException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="application/octet-stream", strict=false)
public class ResponseListener
extends Source<InputStream, CoapResponseAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ResponseListener.class.getCanonicalName());
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ResponseHandler responseHandler;
    private SourceCallback<InputStream, CoapResponseAttributes> sourceCallback = null;

    public void onStart(SourceCallback<InputStream, CoapResponseAttributes> sourceCallback) throws MuleException {
        this.sourceCallback = sourceCallback;
        try {
            ResponseProcessor processor = ResponseProcessor.getResponseProcessor(this.responseHandler.getHandlerName());
            processor.addListener(this.sourceCallback);
        }
        catch (InternalInvalidHandlerException e) {
            throw new StartException((Object)((Object)this) + " failed to start, invalid handler name.", e);
        }
        LOGGER.info("{} started.", (Object)this);
    }

    public void onStop() {
        try {
            ResponseProcessor processor = ResponseProcessor.getResponseProcessor(this.responseHandler.getHandlerName());
            processor.removeListener(this.sourceCallback);
        }
        catch (InternalInvalidHandlerException e) {
            LOGGER.error("{} cannot remove listener", (Object)this);
        }
        this.sourceCallback = null;
        LOGGER.info("{} stopped.", (Object)this);
    }

    public String toString() {
        return "CoAP Response Listener on { " + this.responseHandler.getHandlerName() + " }";
    }
}

