/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.config;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import nl.teslanet.mule.connectors.coap.api.MulticastGroupConfig;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.MulticastParams;
import nl.teslanet.mule.connectors.coap.internal.config.EndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.UdpMulticastConnector;

public class MulticastUdpEndpointConfigVisitor
extends EndpointConfigVisitor {
    private static final String EXCEPTION_FORMAT = "CoAP Endpoint { %s } construction failed. %s: { %s }";
    private UdpMulticastConnector.Builder connectorBuilder = new UdpMulticastConnector.Builder();
    private String multiCastNetworkInterfaceConfig = null;
    private List<MulticastGroupConfig> joinMulticastGroups = null;
    private boolean disableLoopback = false;
    private String outgoingInterface = null;
    private String outgoingAddress = null;

    @Override
    public void visit(MulticastParams toVisit) throws ConfigException {
        super.visit(toVisit);
        this.joinMulticastGroups = toVisit.join;
        this.disableLoopback = toVisit.disableLoopback;
        this.outgoingInterface = toVisit.outgoingMulticastConfig.outgoingInterface;
        this.outgoingAddress = toVisit.outgoingMulticastConfig.outgoingAddress;
    }

    @Override
    public CoapEndpoint getEndpoint() throws EndpointConstructionException {
        this.connectorBuilder.setLocalAddress(this.getLocalAddress());
        if (this.outgoingInterface != null) {
            try {
                this.connectorBuilder.setOutgoingMulticastInterface(NetworkInterface.getByName(this.outgoingInterface));
            }
            catch (SocketException e) {
                throw new EndpointConstructionException(String.format(EXCEPTION_FORMAT, this.getEndpointName(), "Outgoing network interface is invalid", this.outgoingInterface), e);
            }
        }
        if (this.outgoingAddress != null) {
            try {
                this.connectorBuilder.setOutgoingMulticastInterface(InetAddress.getByName(this.outgoingAddress));
            }
            catch (UnknownHostException e) {
                throw new EndpointConstructionException(String.format(EXCEPTION_FORMAT, this.getEndpointName(), "Outgoing network address is invalid", this.outgoingAddress), e);
            }
        }
        if (this.joinMulticastGroups != null) {
            for (MulticastGroupConfig groupConfig : this.joinMulticastGroups) {
                InetAddress groupAddress;
                NetworkInterface networkInterface;
                if (groupConfig.networkInterface == null) {
                    networkInterface = null;
                } else {
                    try {
                        networkInterface = NetworkInterface.getByName(groupConfig.networkInterface);
                    }
                    catch (SocketException e) {
                        throw new EndpointConstructionException(String.format(EXCEPTION_FORMAT, this.getEndpointName(), "Network interface is invalid", this.multiCastNetworkInterfaceConfig), e);
                    }
                }
                try {
                    groupAddress = InetAddress.getByName(groupConfig.group);
                }
                catch (UnknownHostException e) {
                    throw new EndpointConstructionException(String.format(EXCEPTION_FORMAT, this.getEndpointName(), "Multicast group", groupConfig), e);
                }
                this.connectorBuilder.addMulticastGroup(groupAddress, networkInterface);
            }
        }
        this.endpointBuilder.setConfiguration(this.getConfiguration());
        UdpMulticastConnector connector = this.connectorBuilder.build();
        connector.setLoopbackMode(this.disableLoopback);
        this.endpointBuilder.setConnector((Connector)connector);
        return this.endpointBuilder.build();
    }
}

