/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.AbstractEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.DTLSEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.MulticastUDPEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.TCPClientEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.TCPServerEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.TLSClientEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.TLSServerEndpoint;
import nl.teslanet.mule.connectors.coap.api.config.endpoint.UDPEndpoint;
import nl.teslanet.mule.connectors.coap.internal.client.Client;
import nl.teslanet.mule.connectors.coap.internal.config.DtlsEndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.config.MulticastUdpEndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.config.UdpEndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import nl.teslanet.mule.connectors.coap.internal.server.Server;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;

public final class OperationalEndpoint {
    private static final String ENDPOINT_MSG_PREFIX = "CoAP Endpoint { ";
    private static final Map<String, OperationalEndpoint> registry = Collections.synchronizedMap(new HashMap());
    private String configName = null;
    private CoapEndpoint coapEndpoint = null;
    private Optional<Server> server = Optional.empty();
    private HashSet<Client> clients = new HashSet();
    private boolean schedulerIsSet = false;

    private static OperationalEndpoint create(AbstractEndpoint config) throws EndpointConstructionException {
        OperationalEndpoint operationalEndpoint;
        if (config instanceof DTLSEndpoint) {
            operationalEndpoint = new OperationalEndpoint((DTLSEndpoint)config);
        } else if (config instanceof MulticastUDPEndpoint) {
            operationalEndpoint = new OperationalEndpoint((MulticastUDPEndpoint)config);
        } else if (config instanceof UDPEndpoint) {
            operationalEndpoint = new OperationalEndpoint((UDPEndpoint)config);
        } else if (config instanceof TLSServerEndpoint) {
            operationalEndpoint = new OperationalEndpoint((TLSServerEndpoint)config);
        } else if (config instanceof TLSClientEndpoint) {
            operationalEndpoint = new OperationalEndpoint((TLSClientEndpoint)config);
        } else if (config instanceof TCPServerEndpoint) {
            operationalEndpoint = new OperationalEndpoint((TCPServerEndpoint)config);
        } else if (config instanceof TCPClientEndpoint) {
            operationalEndpoint = new OperationalEndpoint((TCPClientEndpoint)config);
        } else {
            throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " }: has unknown type { " + config.getClass().getCanonicalName() + " }");
        }
        if (config.logTraffic) {
            operationalEndpoint.coapEndpoint.addInterceptor((MessageInterceptor)new MessageTracer());
        }
        return operationalEndpoint;
    }

    public static synchronized OperationalEndpoint getOrCreate(Server server, AbstractEndpoint config) throws EndpointConstructionException {
        OperationalEndpoint operationalEndpoint = null;
        Optional<Server> actualServer = Optional.of(server);
        if (registry.containsKey(config.configName)) {
            operationalEndpoint = registry.get(config.configName);
            if (operationalEndpoint.server.isPresent() && !operationalEndpoint.server.equals(actualServer)) {
                throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " }: usage by multiple servers not allowed.");
            }
            operationalEndpoint.server = actualServer;
            return operationalEndpoint;
        }
        operationalEndpoint = OperationalEndpoint.create(config);
        operationalEndpoint.server = actualServer;
        registry.put(operationalEndpoint.getConfigName(), operationalEndpoint);
        return operationalEndpoint;
    }

    public static synchronized OperationalEndpoint getOrCreate(Client client, AbstractEndpoint config) throws EndpointConstructionException {
        OperationalEndpoint operationalEndpoint = null;
        if (client == null) {
            throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " }: no client configured.");
        }
        if (registry.containsKey(config.configName)) {
            operationalEndpoint = registry.get(config.configName);
            operationalEndpoint.clients.add(client);
            return operationalEndpoint;
        }
        operationalEndpoint = OperationalEndpoint.create(config);
        operationalEndpoint.clients.add(client);
        registry.put(operationalEndpoint.getConfigName(), operationalEndpoint);
        return operationalEndpoint;
    }

    public static List<String> find(Server server) {
        Optional<Server> actualServer = Optional.of(server);
        ArrayList<String> found = new ArrayList<String>();
        for (Map.Entry<String, OperationalEndpoint> entry : registry.entrySet()) {
            if (!actualServer.equals(entry.getValue().server)) continue;
            found.add(entry.getKey());
        }
        return found;
    }

    public static List<String> find(Client client) {
        ArrayList<String> found = new ArrayList<String>();
        for (Map.Entry<String, OperationalEndpoint> entry : registry.entrySet()) {
            if (!entry.getValue().clients.contains(client)) continue;
            found.add(entry.getKey());
        }
        return found;
    }

    public static synchronized void disposeAll(Server server) {
        List<String> names = OperationalEndpoint.find(server);
        for (String endpointName : names) {
            OperationalEndpoint endpoint = registry.get(endpointName);
            if (endpoint == null) continue;
            endpoint.server = Optional.empty();
            if (!endpoint.clients.isEmpty()) continue;
            registry.remove(endpointName);
            endpoint.coapEndpoint.destroy();
        }
    }

    public static synchronized void disposeAll(Client client) {
        List<String> names = OperationalEndpoint.find(client);
        for (String endpointName : names) {
            OperationalEndpoint endpoint = registry.get(endpointName);
            if (endpoint == null) continue;
            endpoint.clients.remove(client);
            if (!endpoint.clients.isEmpty() || endpoint.server.isPresent()) continue;
            registry.remove(endpointName);
            endpoint.coapEndpoint.destroy();
        }
    }

    private String getConfigName() {
        return this.configName;
    }

    public CoapEndpoint getCoapEndpoint() {
        return this.coapEndpoint;
    }

    private OperationalEndpoint(UDPEndpoint config) throws EndpointConstructionException {
        UdpEndpointConfigVisitor visitor = new UdpEndpointConfigVisitor();
        try {
            config.accept(visitor);
        }
        catch (ConfigException e) {
            throw new EndpointConstructionException(e);
        }
        this.configName = visitor.getEndpointName();
        this.coapEndpoint = visitor.getEndpoint();
    }

    private OperationalEndpoint(MulticastUDPEndpoint config) throws EndpointConstructionException {
        MulticastUdpEndpointConfigVisitor visitor = new MulticastUdpEndpointConfigVisitor();
        try {
            config.accept(visitor);
        }
        catch (ConfigException e) {
            throw new EndpointConstructionException(e);
        }
        this.configName = visitor.getEndpointName();
        this.coapEndpoint = visitor.getEndpoint();
    }

    private OperationalEndpoint(DTLSEndpoint config) throws EndpointConstructionException {
        DtlsEndpointConfigVisitor visitor = new DtlsEndpointConfigVisitor();
        try {
            config.accept(visitor);
        }
        catch (ConfigException e) {
            throw new EndpointConstructionException(e);
        }
        this.configName = visitor.getEndpointName();
        this.coapEndpoint = visitor.getEndpoint();
    }

    private OperationalEndpoint(TCPServerEndpoint config) throws EndpointConstructionException {
        throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " } TCP Server Endpoint NIY.");
    }

    private OperationalEndpoint(TCPClientEndpoint config) throws EndpointConstructionException {
        throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " } TCP Client Endpoint NIY.");
    }

    private OperationalEndpoint(TLSServerEndpoint config) throws EndpointConstructionException {
        throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " } TLS Server Endpoint NIY.");
    }

    private OperationalEndpoint(TLSClientEndpoint config) throws EndpointConstructionException {
        throw new EndpointConstructionException(ENDPOINT_MSG_PREFIX + config.configName + " } TLS Client Endpoint NIY.");
    }

    public synchronized void setSchedulersIfNeeded(SchedulerService schedulerService, SchedulerConfig schedulerConfig) {
        if (!this.server.isPresent() && !this.schedulerIsSet) {
            Scheduler ioScheduler = schedulerService.ioScheduler(schedulerConfig);
            Scheduler cpuLightScheduler = schedulerService.cpuLightScheduler(schedulerConfig);
            this.coapEndpoint.setExecutors((ScheduledExecutorService)ioScheduler, (ScheduledExecutorService)cpuLightScheduler);
            this.schedulerIsSet = true;
        }
    }

    public synchronized void startIfNeeded() throws IOException {
        if (!this.server.isPresent()) {
            this.coapEndpoint.start();
        }
    }

    public String toString() {
        return ENDPOINT_MSG_PREFIX + this.configName + " }";
    }
}

