/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.CoapResponseCode;
import nl.teslanet.mule.connectors.coap.api.ConfigurableResource;
import nl.teslanet.mule.connectors.coap.api.ResourceConfig;
import nl.teslanet.mule.connectors.coap.api.ResourceParams;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapRequestAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapRequestOptionsAttributesImpl;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidMessageTypeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.options.MediaTypeMediator;
import nl.teslanet.mule.connectors.coap.internal.server.RequestCodeFlags;
import nl.teslanet.mule.connectors.coap.internal.server.ResourceRegistry;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ServedResource
extends CoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServedResource.class);
    private static final Marker ERROR_RESPONSE_MARKER = MarkerFactory.getMarker((String)"ERROR_RESPONSE");
    private static final String NO_LISTENER_LOG_FORMAT = "NO LISTENER for request { {}, {} }";
    private static final String CSV_REGEX = ",";
    private SourceCallback<InputStream, CoapRequestAttributes> getCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> postCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> putCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> deleteCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> fetchCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> patchCallback = null;
    private SourceCallback<InputStream, CoapRequestAttributes> ipatchCallback = null;
    private RequestCodeFlags requestCodeFlags = new RequestCodeFlags();
    private boolean earlyAck = false;

    public ServedResource(ResourceConfig resource) {
        super(resource.getResourceName());
        this.configure(resource);
        if (resource.getSubResources() != null) {
            for (ResourceConfig childResourceConfig : resource.getSubResources()) {
                ServedResource child = new ServedResource(childResourceConfig);
                this.add(child);
            }
        }
    }

    public ServedResource(ResourceParams resource) {
        super(ResourceRegistry.getUriResourceName(resource.getResourcePath()));
        this.configure(resource);
    }

    private void configure(ConfigurableResource resource) {
        this.requestCodeFlags.setGet(resource.isGet());
        this.requestCodeFlags.setPost(resource.isPost());
        this.requestCodeFlags.setPut(resource.isPut());
        this.requestCodeFlags.setDelete(resource.isDelete());
        this.requestCodeFlags.setFetch(resource.isFetch());
        this.requestCodeFlags.setPatch(resource.isPatch());
        this.requestCodeFlags.setIpatch(resource.isIpatch());
        this.earlyAck = resource.isEarlyAck();
        if (resource.isObservable()) {
            this.setObservable(true);
            this.getAttributes().setObservable();
        } else {
            this.setObservable(false);
        }
        if (resource.getCoreInfo() != null) {
            if (resource.getCoreInfo().getTitle() != null) {
                this.getAttributes().setTitle(resource.getCoreInfo().getTitle());
            }
            if (resource.getCoreInfo().getRt() != null) {
                for (String rt : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getRt()).split(CSV_REGEX)) {
                    this.getAttributes().addResourceType(rt);
                }
            }
            if (resource.getCoreInfo().getIfdesc() != null) {
                for (String ifdesc : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getIfdesc()).split(CSV_REGEX)) {
                    this.getAttributes().addInterfaceDescription(ifdesc);
                }
            }
            if (resource.getCoreInfo().getCt() != null) {
                for (String ct : StringUtils.deleteWhitespace((String)resource.getCoreInfo().getCt()).split(CSV_REGEX)) {
                    this.getAttributes().addContentType(Integer.parseInt(ct));
                }
            }
            if (resource.getCoreInfo().getSz() != null) {
                this.getAttributes().setMaximumSizeEstimate(resource.getCoreInfo().getSz());
            }
        }
    }

    public void handleGET(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotGet()) {
            super.handleGET(exchange);
        } else {
            this.handleRequest(this.getCallback, exchange, CoapResponseCode.CONTENT);
        }
    }

    public void handlePUT(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPut()) {
            super.handlePUT(exchange);
        } else {
            this.handleRequest(this.putCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handlePOST(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPost()) {
            super.handlePOST(exchange);
        } else {
            this.handleRequest(this.postCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handleDELETE(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotDelete()) {
            super.handleDELETE(exchange);
        } else {
            this.handleRequest(this.deleteCallback, exchange, CoapResponseCode.DELETED);
        }
    }

    public void handleFETCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotFetch()) {
            super.handleFETCH(exchange);
        } else {
            this.handleRequest(this.fetchCallback, exchange, CoapResponseCode.CONTENT);
        }
    }

    public void handlePATCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotPatch()) {
            super.handlePATCH(exchange);
        } else {
            this.handleRequest(this.patchCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    public void handleIPATCH(CoapExchange exchange) {
        if (this.requestCodeFlags.isNotIpatch()) {
            super.handleIPATCH(exchange);
        } else {
            this.handleRequest(this.ipatchCallback, exchange, CoapResponseCode.CHANGED);
        }
    }

    private void handleRequest(SourceCallback<InputStream, CoapRequestAttributes> callback, CoapExchange exchange, CoapResponseCode defaultCoAPResponseCode) {
        CoapRequestAttributesImpl requestAttributes;
        if (callback == null) {
            exchange.respond(CoAP.ResponseCode.NOT_IMPLEMENTED, "NO LISTENER");
            if (LOGGER.isWarnEnabled(ERROR_RESPONSE_MARKER)) {
                try {
                    LOGGER.warn(ERROR_RESPONSE_MARKER, NO_LISTENER_LOG_FORMAT, (Object)AttributeUtils.toRequestCodeAttribute(exchange.advanced().getCurrentRequest().getCode()), (Object)exchange.advanced().getCurrentRequest().getURI());
                }
                catch (InternalInvalidRequestCodeException e) {
                    LOGGER.warn(ERROR_RESPONSE_MARKER, NO_LISTENER_LOG_FORMAT, (Object)exchange.advanced().getCurrentRequest().getCode(), (Object)exchange.advanced().getCurrentRequest().getURI());
                }
            }
            return;
        }
        if (this.earlyAck) {
            exchange.accept();
        }
        try {
            requestAttributes = this.createRequestAttributes(exchange);
        }
        catch (Exception e1) {
            Response response = new Response(CoAP.ResponseCode.BAD_OPTION);
            response.setPayload(e1.getMessage());
            exchange.respond(response);
            return;
        }
        SourceCallbackContext requestcontext = callback.createContext();
        requestcontext.addVariable("defaultResponseCode", (Object)defaultCoAPResponseCode);
        requestcontext.addVariable("coapExchange", (Object)exchange);
        byte[] requestPayload = exchange.getRequestPayload();
        callback.handle(Result.builder().output((Object)new ByteArrayInputStream(requestPayload)).length((long)requestPayload.length).attributes((Object)requestAttributes).mediaType(MediaTypeMediator.toMediaType(exchange.getRequestOptions().getContentFormat())).build(), requestcontext);
    }

    private CoapRequestAttributesImpl createRequestAttributes(CoapExchange coapExchange) throws InternalInvalidOptionValueException, InternalInvalidMessageTypeException, InternalInvalidRequestCodeException {
        Exchange exchange = coapExchange.advanced();
        CoapRequestAttributesImpl attributes = new CoapRequestAttributesImpl();
        attributes.setRequestType(AttributeUtils.toMessageTypeAttribute(coapExchange.advanced().getRequest().getType()).name());
        attributes.setRequestCode(AttributeUtils.toRequestCodeAttribute(coapExchange.getRequestCode()).name());
        attributes.setLocalAddress(exchange.getEndpoint().getAddress().toString());
        attributes.setRemoteAddress(coapExchange.getSourceSocketAddress().toString());
        attributes.setRequestUri(exchange.getRequest().getURI());
        attributes.setRequestOptions(new CoapRequestOptionsAttributesImpl(coapExchange.getRequestOptions()));
        attributes.setRelation(exchange.getRelation() != null ? exchange.getRelation().getKeyToken().toString() : null);
        return attributes;
    }

    public void setGetCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.getCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getGetCallback() {
        return this.getCallback;
    }

    public void setPostCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.postCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPostCallback() {
        return this.postCallback;
    }

    public void setPutCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.putCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPutCallback() {
        return this.putCallback;
    }

    public void setDeleteCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.deleteCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getDeleteCallback() {
        return this.deleteCallback;
    }

    public void setFetchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.fetchCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getFetchCallback() {
        return this.fetchCallback;
    }

    public void setPatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.patchCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getPatchCallback() {
        return this.patchCallback;
    }

    public void setIpatchCallback(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) {
        this.ipatchCallback = sourceCallback;
    }

    public SourceCallback<InputStream, CoapRequestAttributes> getIpatchCallback() {
        return this.ipatchCallback;
    }
}

