/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import nl.teslanet.mule.connectors.coap.api.ResourceParams;
import nl.teslanet.mule.connectors.coap.api.error.InvalidResourceUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.ServerOperationErrorProvider;
import nl.teslanet.mule.connectors.coap.internal.server.ResourceRegistry;
import nl.teslanet.mule.connectors.coap.internal.server.ServedResource;
import nl.teslanet.mule.connectors.coap.internal.server.Server;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ServerOperations {
    @Throws(value={ServerOperationErrorProvider.class})
    public void notify(@Config Server server, @Alias(value="pathPattern") @Summary(value="For resources that apply to the path-pattern notifications are issued.") @Example(value="/my_resources/*") String pathPattern) throws InvalidResourceUriException {
        if (pathPattern == null) {
            throw new InvalidResourceUriException(server + ": notify operation failed, invalid uri.", "null");
        }
        for (ServedResource resource : server.getRegistry().findResources(pathPattern)) {
            resource.changed();
        }
    }

    @Throws(value={ServerOperationErrorProvider.class})
    public void resourceAdd(@Config Server server, @ParameterGroup(name="Resource to add") ResourceParams resourceParams) throws InvalidResourceUriException {
        if (resourceParams.getResourcePath() == null) {
            throw new InvalidResourceUriException(server + ": resource add operation failed,", "null");
        }
        String parentUri = ResourceRegistry.getParentUri(resourceParams.getResourcePath());
        String name = ResourceRegistry.getUriResourceName(resourceParams.getResourcePath());
        if (name.length() <= 0) {
            throw new InvalidResourceUriException(server + ": resource add operation failed, empty resource name", resourceParams.getResourcePath());
        }
        try {
            server.getRegistry().add(parentUri, resourceParams);
        }
        catch (InternalResourceUriException e) {
            throw new InvalidResourceUriException(server + ": resource add operation failed, ", resourceParams.getResourcePath(), e);
        }
    }

    @Throws(value={ServerOperationErrorProvider.class})
    public void resourceRemove(@Config Server server, @Alias(value="pathPattern") @Summary(value="Resources that apply to the path-pattern are removed.") @Example(value="/resources/*") String pathPattern) throws InvalidResourceUriException {
        if (pathPattern == null) {
            throw new InvalidResourceUriException(server + ": resource remove operation failed", "null");
        }
        server.getRegistry().remove(pathPattern);
    }

    @Throws(value={ServerOperationErrorProvider.class})
    public boolean resourceExists(@Config Server server, @Alias(value="pathPattern") @Summary(value="If any resources that apply to the path-pattern exist true is retuned, otherwise false.") @Example(value="/resources/*") String pathPattern) throws InvalidResourceUriException {
        if (pathPattern == null) {
            throw new InvalidResourceUriException(server + ": resource exists operation failed", "null");
        }
        List<ServedResource> found = server.getRegistry().findResources(pathPattern);
        return !found.isEmpty();
    }

    @Throws(value={ServerOperationErrorProvider.class})
    public Set<String> resourceList(@Config Server server, @Alias(value="pathPattern") @Summary(value="Get the set of paths of the resources that apply to the path-pattern.") String pathPattern) throws InvalidResourceUriException {
        if (pathPattern == null) {
            throw new InvalidResourceUriException(server + ": resource list operation failed", "null");
        }
        LinkedList<String> uriList = new LinkedList<String>();
        for (ServedResource found : server.getRegistry().findResources(pathPattern)) {
            uriList.add(found.getURI());
        }
        return new ConcurrentSkipListSet<String>(uriList);
    }
}

