/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.teslanet.mule.connectors.coap.api.CoapMessageType;
import nl.teslanet.mule.connectors.coap.api.CoapRequestCode;
import nl.teslanet.mule.connectors.coap.api.CoapResponseCode;
import nl.teslanet.mule.connectors.coap.api.attributes.Result;
import nl.teslanet.mule.connectors.coap.api.options.OtherOptionAttribute;
import nl.teslanet.mule.connectors.coap.api.query.QueryParamAttribute;
import nl.teslanet.mule.connectors.coap.internal.attributes.CoapOtherOptionAttributeImpl;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidMessageTypeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidRequestCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidResponseCodeException;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;

public class AttributeUtils {
    private AttributeUtils() {
    }

    public static CoAP.Type toMessageType(CoapMessageType type) throws InternalInvalidMessageTypeException {
        switch (type) {
            case CONFIRMABLE: {
                return CoAP.Type.CON;
            }
            case NON_CONFIRMABLE: {
                return CoAP.Type.NON;
            }
            case ACKNOWLEDGEMENT: {
                return CoAP.Type.ACK;
            }
            case RESET: {
                return CoAP.Type.RST;
            }
        }
        throw new InternalInvalidMessageTypeException("Invalid message type { " + (Object)((Object)type) + " }");
    }

    public static CoapMessageType toMessageTypeAttribute(CoAP.Type type) throws InternalInvalidMessageTypeException {
        switch (type) {
            case CON: {
                return CoapMessageType.CONFIRMABLE;
            }
            case NON: {
                return CoapMessageType.NON_CONFIRMABLE;
            }
            case ACK: {
                return CoapMessageType.ACKNOWLEDGEMENT;
            }
            case RST: {
                return CoapMessageType.RESET;
            }
        }
        throw new InternalInvalidMessageTypeException("Invalid message type { " + type + " }");
    }

    public static CoAP.Code toRequestCode(CoapRequestCode requestCodeAttribute) throws InternalInvalidRequestCodeException {
        switch (requestCodeAttribute) {
            case GET: {
                return CoAP.Code.GET;
            }
            case POST: {
                return CoAP.Code.POST;
            }
            case PUT: {
                return CoAP.Code.PUT;
            }
            case DELETE: {
                return CoAP.Code.DELETE;
            }
            case FETCH: {
                return CoAP.Code.FETCH;
            }
            case PATCH: {
                return CoAP.Code.PATCH;
            }
            case IPATCH: {
                return CoAP.Code.IPATCH;
            }
        }
        throw new InternalInvalidRequestCodeException("invalid request code { " + (Object)((Object)requestCodeAttribute) + " }");
    }

    public static CoapRequestCode toRequestCodeAttribute(CoAP.Code code) throws InternalInvalidRequestCodeException {
        switch (code) {
            case GET: {
                return CoapRequestCode.GET;
            }
            case POST: {
                return CoapRequestCode.POST;
            }
            case PUT: {
                return CoapRequestCode.PUT;
            }
            case DELETE: {
                return CoapRequestCode.DELETE;
            }
            case FETCH: {
                return CoapRequestCode.FETCH;
            }
            case PATCH: {
                return CoapRequestCode.PATCH;
            }
            case IPATCH: {
                return CoapRequestCode.IPATCH;
            }
        }
        throw new InternalInvalidRequestCodeException("invalid request code { " + code + " }");
    }

    public static CoAP.ResponseCode toResponseCode(CoapResponseCode reponseCodeAttribute, CoapResponseCode defaultResponseCodeAttribute) throws InternalInvalidResponseCodeException {
        if (reponseCodeAttribute != null) {
            return AttributeUtils.toResponseCode(reponseCodeAttribute);
        }
        return AttributeUtils.toResponseCode(defaultResponseCodeAttribute);
    }

    public static CoAP.ResponseCode toResponseCode(CoapResponseCode reponseCodeAttribute) throws InternalInvalidResponseCodeException {
        switch (reponseCodeAttribute) {
            case CREATED: {
                return CoAP.ResponseCode.CREATED;
            }
            case DELETED: {
                return CoAP.ResponseCode.DELETED;
            }
            case VALID: {
                return CoAP.ResponseCode.VALID;
            }
            case CHANGED: {
                return CoAP.ResponseCode.CHANGED;
            }
            case CONTENT: {
                return CoAP.ResponseCode.CONTENT;
            }
            case CONTINUE: {
                return CoAP.ResponseCode.CONTINUE;
            }
            case BAD_REQUEST: {
                return CoAP.ResponseCode.BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return CoAP.ResponseCode.UNAUTHORIZED;
            }
            case BAD_OPTION: {
                return CoAP.ResponseCode.BAD_OPTION;
            }
            case FORBIDDEN: {
                return CoAP.ResponseCode.FORBIDDEN;
            }
            case NOT_FOUND: {
                return CoAP.ResponseCode.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return CoAP.ResponseCode.METHOD_NOT_ALLOWED;
            }
            case NOT_ACCEPTABLE: {
                return CoAP.ResponseCode.NOT_ACCEPTABLE;
            }
            case REQUEST_ENTITY_INCOMPLETE: {
                return CoAP.ResponseCode.REQUEST_ENTITY_INCOMPLETE;
            }
            case CONFLICT: {
                return CoAP.ResponseCode.CONFLICT;
            }
            case PRECONDITION_FAILED: {
                return CoAP.ResponseCode.PRECONDITION_FAILED;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return CoAP.ResponseCode.REQUEST_ENTITY_TOO_LARGE;
            }
            case UNSUPPORTED_CONTENT_FORMAT: {
                return CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT;
            }
            case UNPROCESSABLE_ENTITY: {
                return CoAP.ResponseCode.UNPROCESSABLE_ENTITY;
            }
            case TOO_MANY_REQUESTS: {
                return CoAP.ResponseCode.TOO_MANY_REQUESTS;
            }
            case INTERNAL_SERVER_ERROR: {
                return CoAP.ResponseCode.INTERNAL_SERVER_ERROR;
            }
            case NOT_IMPLEMENTED: {
                return CoAP.ResponseCode.NOT_IMPLEMENTED;
            }
            case BAD_GATEWAY: {
                return CoAP.ResponseCode.BAD_GATEWAY;
            }
            case SERVICE_UNAVAILABLE: {
                return CoAP.ResponseCode.SERVICE_UNAVAILABLE;
            }
            case GATEWAY_TIMEOUT: {
                return CoAP.ResponseCode.GATEWAY_TIMEOUT;
            }
            case PROXY_NOT_SUPPORTED: {
                return CoAP.ResponseCode.PROXY_NOT_SUPPORTED;
            }
        }
        throw new InternalInvalidResponseCodeException(reponseCodeAttribute);
    }

    public static CoapResponseCode toResponseCodeAttribute(CoAP.ResponseCode reponseCode) throws InternalInvalidResponseCodeException {
        switch (reponseCode) {
            case CREATED: {
                return CoapResponseCode.CREATED;
            }
            case DELETED: {
                return CoapResponseCode.DELETED;
            }
            case VALID: {
                return CoapResponseCode.VALID;
            }
            case CHANGED: {
                return CoapResponseCode.CHANGED;
            }
            case CONTENT: {
                return CoapResponseCode.CONTENT;
            }
            case CONTINUE: {
                return CoapResponseCode.CONTINUE;
            }
            case BAD_REQUEST: {
                return CoapResponseCode.BAD_REQUEST;
            }
            case UNAUTHORIZED: {
                return CoapResponseCode.UNAUTHORIZED;
            }
            case BAD_OPTION: {
                return CoapResponseCode.BAD_OPTION;
            }
            case FORBIDDEN: {
                return CoapResponseCode.FORBIDDEN;
            }
            case NOT_FOUND: {
                return CoapResponseCode.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return CoapResponseCode.METHOD_NOT_ALLOWED;
            }
            case NOT_ACCEPTABLE: {
                return CoapResponseCode.NOT_ACCEPTABLE;
            }
            case REQUEST_ENTITY_INCOMPLETE: {
                return CoapResponseCode.REQUEST_ENTITY_INCOMPLETE;
            }
            case CONFLICT: {
                return CoapResponseCode.CONFLICT;
            }
            case PRECONDITION_FAILED: {
                return CoapResponseCode.PRECONDITION_FAILED;
            }
            case REQUEST_ENTITY_TOO_LARGE: {
                return CoapResponseCode.REQUEST_ENTITY_TOO_LARGE;
            }
            case UNSUPPORTED_CONTENT_FORMAT: {
                return CoapResponseCode.UNSUPPORTED_CONTENT_FORMAT;
            }
            case UNPROCESSABLE_ENTITY: {
                return CoapResponseCode.UNPROCESSABLE_ENTITY;
            }
            case TOO_MANY_REQUESTS: {
                return CoapResponseCode.TOO_MANY_REQUESTS;
            }
            case INTERNAL_SERVER_ERROR: {
                return CoapResponseCode.INTERNAL_SERVER_ERROR;
            }
            case NOT_IMPLEMENTED: {
                return CoapResponseCode.NOT_IMPLEMENTED;
            }
            case BAD_GATEWAY: {
                return CoapResponseCode.BAD_GATEWAY;
            }
            case SERVICE_UNAVAILABLE: {
                return CoapResponseCode.SERVICE_UNAVAILABLE;
            }
            case GATEWAY_TIMEOUT: {
                return CoapResponseCode.GATEWAY_TIMEOUT;
            }
            case PROXY_NOT_SUPPORTED: {
                return CoapResponseCode.PROXY_NOT_SUPPORTED;
            }
        }
        throw new InternalInvalidResponseCodeException(reponseCode);
    }

    public static void addQueryParam(List<QueryParamAttribute> list, String parameterString) {
        String value;
        String key;
        int separatorIndex = parameterString.indexOf("=");
        if (separatorIndex < 0) {
            key = parameterString;
            value = null;
        } else {
            key = parameterString.substring(0, separatorIndex);
            value = parameterString.substring(separatorIndex + 1);
        }
        list.add(new QueryParamAttribute(key, value));
    }

    public static List<OtherOptionAttribute> createOthers(List<Option> otherCoapOptions) {
        ArrayList<CoapOtherOptionAttributeImpl> others = new ArrayList<CoapOtherOptionAttributeImpl>();
        for (Option other : otherCoapOptions) {
            CoapOtherOptionAttributeImpl otherOptionAttribute = new CoapOtherOptionAttributeImpl(other);
            others.add(otherOptionAttribute);
        }
        return Collections.unmodifiableList(others);
    }

    public static Result toResult(CoAP.ResponseCode code) {
        if (code.isSuccess()) {
            return Result.SUCCESS;
        }
        if (code.isClientError()) {
            return Result.CLIENT_ERROR;
        }
        if (code.isServerError()) {
            return Result.SERVER_ERROR;
        }
        return Result.NO_RESPONSE;
    }
}

