/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.utils;

import java.util.ArrayList;
import java.util.List;
import nl.teslanet.mule.connectors.coap.api.config.security.CertificateKeyAlgorithm;
import nl.teslanet.mule.connectors.coap.api.config.security.CertificateKeyAlgorithmName;
import nl.teslanet.mule.connectors.coap.api.config.security.CipherSuiteName;
import nl.teslanet.mule.connectors.coap.api.config.security.Curve;
import nl.teslanet.mule.connectors.coap.api.config.security.ExtendedMasterSecretModeName;
import nl.teslanet.mule.connectors.coap.api.config.security.HashAlgorithmName;
import nl.teslanet.mule.connectors.coap.api.config.security.SignatureAlgorithm;
import nl.teslanet.mule.connectors.coap.api.config.security.SignatureAlgorithmName;
import nl.teslanet.mule.connectors.coap.api.config.security.SupportedGroupName;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;

public class SecurityUtils {
    private SecurityUtils() {
    }

    public static CipherSuite toCfCipherSuite(CipherSuiteName name) {
        if (name != null) {
            switch (name) {
                case TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_128_CCM: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_256_CCM: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CCM;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8;
                }
                case TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384: {
                    return CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
                }
                case TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256: {
                    return CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256;
                }
                case TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256: {
                    return CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256;
                }
                case TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256: {
                    return CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256;
                }
                case TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256: {
                    return CipherSuite.TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256;
                }
                case TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384: {
                    return CipherSuite.TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA378;
                }
                case TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256: {
                    return CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256;
                }
                case TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256: {
                    return CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
                }
                case TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA: {
                    return CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
                }
                case TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384: {
                    return CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384;
                }
                case TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384: {
                    return CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
                }
                case TLS_EMPTY_RENEGOTIATION_INFO_SCSV: {
                    return CipherSuite.TLS_EMPTY_RENEGOTIATION_INFO_SCSV;
                }
                case TLS_PSK_WITH_AES_128_CBC_SHA256: {
                    return CipherSuite.TLS_PSK_WITH_AES_128_CBC_SHA256;
                }
                case TLS_PSK_WITH_AES_128_CCM: {
                    return CipherSuite.TLS_PSK_WITH_AES_128_CCM;
                }
                case TLS_PSK_WITH_AES_128_CCM_8: {
                    return CipherSuite.TLS_PSK_WITH_AES_128_CCM_8;
                }
                case TLS_PSK_WITH_AES_128_GCM_SHA256: {
                    return CipherSuite.TLS_PSK_WITH_AES_128_GCM_SHA256;
                }
                case TLS_PSK_WITH_AES_256_CCM: {
                    return CipherSuite.TLS_PSK_WITH_AES_256_CCM;
                }
                case TLS_PSK_WITH_AES_256_CCM_8: {
                    return CipherSuite.TLS_PSK_WITH_AES_256_CCM_8;
                }
                case TLS_PSK_WITH_AES_256_GCM_SHA384: {
                    return CipherSuite.TLS_PSK_WITH_AES_256_GCM_SHA378;
                }
            }
        }
        return null;
    }

    public static List<CipherSuite> toCfCipherSuites(List<nl.teslanet.mule.connectors.coap.api.config.security.CipherSuite> suites) {
        ArrayList<CipherSuite> cfSuites = new ArrayList<CipherSuite>();
        for (nl.teslanet.mule.connectors.coap.api.config.security.CipherSuite suite : suites) {
            CipherSuite cfSuite = SecurityUtils.toCfCipherSuite(suite.getCipherSuiteName());
            if (cfSuite == null) continue;
            cfSuites.add(cfSuite);
        }
        return cfSuites;
    }

    public static XECDHECryptography.SupportedGroup toCfCurve(SupportedGroupName name) {
        if (name != null) {
            switch (name) {
                case X25519: {
                    return XECDHECryptography.SupportedGroup.X25519;
                }
                case X448: {
                    return XECDHECryptography.SupportedGroup.X448;
                }
                case arbitrary_explicit_char2_curves: {
                    return XECDHECryptography.SupportedGroup.arbitrary_explicit_char2_curves;
                }
                case arbitrary_explicit_prime_curves: {
                    return XECDHECryptography.SupportedGroup.arbitrary_explicit_prime_curves;
                }
                case brainpoolP256r1: {
                    return XECDHECryptography.SupportedGroup.brainpoolP256r1;
                }
                case brainpoolP384r1: {
                    return XECDHECryptography.SupportedGroup.brainpoolP384r1;
                }
                case brainpoolP512r1: {
                    return XECDHECryptography.SupportedGroup.brainpoolP512r1;
                }
                case ffdhe2048: {
                    return XECDHECryptography.SupportedGroup.ffdhe2048;
                }
                case ffdhe3072: {
                    return XECDHECryptography.SupportedGroup.ffdhe3072;
                }
                case ffdhe4096: {
                    return XECDHECryptography.SupportedGroup.ffdhe4096;
                }
                case ffdhe6144: {
                    return XECDHECryptography.SupportedGroup.ffdhe6144;
                }
                case ffdhe8192: {
                    return XECDHECryptography.SupportedGroup.ffdhe8192;
                }
                case secp160k1: {
                    return XECDHECryptography.SupportedGroup.secp160k1;
                }
                case secp160r1: {
                    return XECDHECryptography.SupportedGroup.secp160r1;
                }
                case secp160r2: {
                    return XECDHECryptography.SupportedGroup.secp160r2;
                }
                case secp192k1: {
                    return XECDHECryptography.SupportedGroup.secp192k1;
                }
                case secp192r1: {
                    return XECDHECryptography.SupportedGroup.secp192r1;
                }
                case secp224k1: {
                    return XECDHECryptography.SupportedGroup.secp224k1;
                }
                case secp224r1: {
                    return XECDHECryptography.SupportedGroup.secp224r1;
                }
                case secp256k1: {
                    return XECDHECryptography.SupportedGroup.secp256k1;
                }
                case secp256r1: {
                    return XECDHECryptography.SupportedGroup.secp256r1;
                }
                case secp384r1: {
                    return XECDHECryptography.SupportedGroup.secp384r1;
                }
                case secp521r1: {
                    return XECDHECryptography.SupportedGroup.secp521r1;
                }
                case sect163k1: {
                    return XECDHECryptography.SupportedGroup.sect163k1;
                }
                case sect163r1: {
                    return XECDHECryptography.SupportedGroup.sect163r1;
                }
                case sect163r2: {
                    return XECDHECryptography.SupportedGroup.sect163r2;
                }
                case sect193r1: {
                    return XECDHECryptography.SupportedGroup.sect193r1;
                }
                case sect193r2: {
                    return XECDHECryptography.SupportedGroup.sect193r2;
                }
                case sect233k1: {
                    return XECDHECryptography.SupportedGroup.sect233k1;
                }
                case sect233r1: {
                    return XECDHECryptography.SupportedGroup.sect233r1;
                }
                case sect239k1: {
                    return XECDHECryptography.SupportedGroup.sect239k1;
                }
                case sect283k1: {
                    return XECDHECryptography.SupportedGroup.sect283k1;
                }
                case sect283r1: {
                    return XECDHECryptography.SupportedGroup.sect283r1;
                }
                case sect409k1: {
                    return XECDHECryptography.SupportedGroup.sect409k1;
                }
                case sect409r1: {
                    return XECDHECryptography.SupportedGroup.sect409r1;
                }
                case sect571k1: {
                    return XECDHECryptography.SupportedGroup.sect571k1;
                }
                case sect571r1: {
                    return XECDHECryptography.SupportedGroup.sect571r1;
                }
            }
        }
        return null;
    }

    public static List<XECDHECryptography.SupportedGroup> toCfCurves(List<Curve> curves) {
        ArrayList<XECDHECryptography.SupportedGroup> cfCurves = new ArrayList<XECDHECryptography.SupportedGroup>();
        for (Curve curve : curves) {
            XECDHECryptography.SupportedGroup cfCurve = SecurityUtils.toCfCurve(curve.getCurveName());
            if (cfCurve == null) continue;
            cfCurves.add(cfCurve);
        }
        return cfCurves;
    }

    public static SignatureAndHashAlgorithm toCfSignatureAndHashAlgoritm(HashAlgorithmName hashAlgorithm, SignatureAlgorithmName signatureAlgorithm) {
        SignatureAndHashAlgorithm.SignatureAlgorithm cfSignatureAlgorithm;
        SignatureAndHashAlgorithm.HashAlgorithm cfHhashAlgorithm;
        switch (hashAlgorithm) {
            case MD5: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.MD5;
                break;
            }
            case NONE: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.NONE;
                break;
            }
            case SHA1: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.SHA1;
                break;
            }
            case SHA224: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.SHA224;
                break;
            }
            case SHA256: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.SHA256;
                break;
            }
            case SHA384: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.SHA384;
                break;
            }
            case SHA512: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.SHA512;
                break;
            }
            default: {
                cfHhashAlgorithm = SignatureAndHashAlgorithm.HashAlgorithm.INTRINSIC;
            }
        }
        switch (signatureAlgorithm) {
            case DSA: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.DSA;
                break;
            }
            case ECDSA: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.ECDSA;
                break;
            }
            case ED25519: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.ED25519;
                break;
            }
            case ED448: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.ED448;
                break;
            }
            case RSA: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.RSA;
                break;
            }
            default: {
                cfSignatureAlgorithm = SignatureAndHashAlgorithm.SignatureAlgorithm.ANONYMOUS;
            }
        }
        return new SignatureAndHashAlgorithm(cfHhashAlgorithm, cfSignatureAlgorithm);
    }

    public static List<SignatureAndHashAlgorithm> toCfSignatureAndHashAlgoritms(List<SignatureAlgorithm> signatureAlgorithms) {
        ArrayList<SignatureAndHashAlgorithm> cfAlgorithms = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAlgorithm algortithm : signatureAlgorithms) {
            SignatureAndHashAlgorithm cfAlgoritm = SecurityUtils.toCfSignatureAndHashAlgoritm(algortithm.hashAlgorithm, algortithm.algorithm);
            cfAlgorithms.add(cfAlgoritm);
        }
        return cfAlgorithms;
    }

    public static CipherSuite.CertificateKeyAlgorithm toCfCertificateKeyAlgorithm(CertificateKeyAlgorithmName name) {
        if (name != null) {
            switch (name) {
                case EC: {
                    return CipherSuite.CertificateKeyAlgorithm.EC;
                }
                case RSA: {
                    return CipherSuite.CertificateKeyAlgorithm.RSA;
                }
            }
        }
        return null;
    }

    public static List<CipherSuite.CertificateKeyAlgorithm> toCfCertificateKeyAlgorithms(List<CertificateKeyAlgorithm> certificateKeyAlgorithms) {
        ArrayList<CipherSuite.CertificateKeyAlgorithm> cfAlgorithms = new ArrayList<CipherSuite.CertificateKeyAlgorithm>();
        for (CertificateKeyAlgorithm algorithm : certificateKeyAlgorithms) {
            CipherSuite.CertificateKeyAlgorithm cfAlgorithm = SecurityUtils.toCfCertificateKeyAlgorithm(algorithm.getAlgorithm());
            if (cfAlgorithm == null) continue;
            cfAlgorithms.add(cfAlgorithm);
        }
        return cfAlgorithms;
    }

    public static ExtendedMasterSecretMode toCfExtendedMasterSecretMode(ExtendedMasterSecretModeName extendedMasterSecretMode) {
        if (extendedMasterSecretMode != null) {
            switch (extendedMasterSecretMode) {
                case ENABLED: {
                    return ExtendedMasterSecretMode.ENABLED;
                }
                case NONE: {
                    return ExtendedMasterSecretMode.NONE;
                }
                case OPTIONAL: {
                    return ExtendedMasterSecretMode.OPTIONAL;
                }
                case REQUIRED: {
                    return ExtendedMasterSecretMode.REQUIRED;
                }
            }
        }
        return null;
    }
}

