/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api;

import java.util.List;
import nl.teslanet.mule.connectors.coap.api.ConfigurableResource;
import nl.teslanet.mule.connectors.coap.api.CoreInfo;
import nl.teslanet.mule.connectors.coap.api.NewSubResource;
import nl.teslanet.mule.connectors.coap.api.NewSubResourceConfig;
import nl.teslanet.mule.connectors.coap.api.ResourceInfoConfig;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="resource")
public class ResourceConfig
implements ConfigurableResource {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The name of the resource that will be used to identify it in CoAP uri's.")
    @Example(value="my_resource")
    private String resourceName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, GET requests are allowed on the resource.")
    private boolean get = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, POST requests are allowed on the resource.")
    private boolean post = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, PUT requests are allowed on the resource.")
    private boolean put = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, DELETE requests are allowed on the resource.")
    private boolean delete = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, Fetch requests are allowed on the resource.")
    private boolean fetch = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, PATCH requests are allowed on the resource.")
    private boolean patch = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, iPatch requests are allowed on the resource.")
    private boolean ipatch = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true, the resource can be observed by clients.")
    private boolean observable = false;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="When true an acknowledgement is immediately sent to the client, before processing the request.")
    private boolean earlyAck = false;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The CoRE information describing the contrained resource for discovery.")
    @DisplayName(value="Discovery CoRE Info")
    private ResourceInfoConfig coreInfoConfig = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The creation by clients of subordinate resources configuration.")
    @DisplayName(value="New sub-resource creation by client")
    private NewSubResourceConfig newSubResourceConfig = null;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="The subordinate resources of the resource.")
    private List<ResourceConfig> subResources = null;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public boolean isGet() {
        return this.get;
    }

    public void setGet(boolean get) {
        this.get = get;
    }

    @Override
    public boolean isPost() {
        return this.post;
    }

    public void setPost(boolean post) {
        this.post = post;
    }

    @Override
    public boolean isPut() {
        return this.put;
    }

    public void setPut(boolean put) {
        this.put = put;
    }

    @Override
    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Override
    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    @Override
    public boolean isPatch() {
        return this.patch;
    }

    public void setPatch(boolean patch) {
        this.patch = patch;
    }

    @Override
    public boolean isIpatch() {
        return this.ipatch;
    }

    public void setIpatch(boolean ipatch) {
        this.ipatch = ipatch;
    }

    @Override
    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    @Override
    public boolean isEarlyAck() {
        return this.earlyAck;
    }

    public void setEarlyAck(boolean earlyAck) {
        this.earlyAck = earlyAck;
    }

    @Override
    public CoreInfo getCoreInfo() {
        return this.coreInfoConfig;
    }

    public void setCoreInfo(ResourceInfoConfig coreInfo) {
        this.coreInfoConfig = coreInfo;
    }

    @Override
    public NewSubResource getNewSubResource() {
        return this.newSubResourceConfig;
    }

    public void setNewSubResource(NewSubResource newSubresource) {
        this.newSubResourceConfig = new NewSubResourceConfig(newSubresource.isPut(), newSubresource.isEarlyAck());
    }

    public List<ResourceConfig> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(List<ResourceConfig> resources) {
        this.subResources = resources;
    }

    public String toString() {
        return "CoAP Resource config { " + this.resourceName + " }";
    }
}

