/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.endpoint;

import nl.teslanet.mule.connectors.coap.api.config.BlockwiseParams;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.ExchangeParams;
import nl.teslanet.mule.connectors.coap.api.config.LogHealthStatus;
import nl.teslanet.mule.connectors.coap.api.config.NotificationParams;
import nl.teslanet.mule.connectors.coap.api.config.SocketParams;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import nl.teslanet.mule.connectors.coap.api.config.midtracker.GroupedMidTracker;
import nl.teslanet.mule.connectors.coap.api.config.options.OptionParams;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class AbstractEndpoint
implements VisitableConfig {
    @RefName
    public String configName;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Placement(order=1)
    public SocketParams socketParams;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public BlockwiseParams blockwiseParams = null;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public NotificationParams notificationParams = null;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public OptionParams optionParams = null;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public ExchangeParams exchangeParams = null;
    @Parameter
    @Optional
    @Summary(value="When activated logHealthStatus is periodically logged.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public LogHealthStatus logHealthStatus = null;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="When activated incoming and outgoing CoAP traffic is logged.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean logTraffic = false;

    protected AbstractEndpoint() {
    }

    protected AbstractEndpoint(String name) {
        this.configName = name;
        this.socketParams = new SocketParams();
        this.blockwiseParams = new BlockwiseParams();
        this.notificationParams = new NotificationParams();
        this.exchangeParams = new ExchangeParams(new GroupedMidTracker());
    }

    protected AbstractEndpoint(String name, int port) {
        this(name);
        this.socketParams.bindToPort = port;
    }

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
        this.socketParams.accept(visitor);
        this.blockwiseParams.accept(visitor);
        this.notificationParams.accept(visitor);
        if (this.optionParams != null) {
            this.optionParams.accept(visitor);
        }
        this.exchangeParams.accept(visitor);
        if (this.logHealthStatus != null) {
            this.logHealthStatus.accept(visitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractEndpoint rhs = (AbstractEndpoint)obj;
        return new EqualsBuilder().append((Object)this.configName, (Object)rhs.configName).append((Object)this.socketParams, (Object)rhs.socketParams).append((Object)this.blockwiseParams, (Object)rhs.blockwiseParams).append((Object)this.notificationParams, (Object)rhs.notificationParams).append((Object)this.optionParams, (Object)rhs.optionParams).append((Object)this.exchangeParams, (Object)rhs.exchangeParams).append((Object)this.logHealthStatus, (Object)rhs.logHealthStatus).append(this.logTraffic, rhs.logTraffic).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.configName).append((Object)this.socketParams).append((Object)this.blockwiseParams).append((Object)this.notificationParams).append((Object)this.optionParams).append((Object)this.exchangeParams).append((Object)this.logHealthStatus).append(this.logTraffic).toHashCode();
    }
}

