/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.config.security;

import java.util.List;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.ConfigVisitor;
import nl.teslanet.mule.connectors.coap.api.config.VisitableConfig;
import nl.teslanet.mule.connectors.coap.api.config.security.CertificateKeyAlgorithm;
import nl.teslanet.mule.connectors.coap.api.config.security.CipherSuite;
import nl.teslanet.mule.connectors.coap.api.config.security.ConnectionId;
import nl.teslanet.mule.connectors.coap.api.config.security.Curve;
import nl.teslanet.mule.connectors.coap.api.config.security.ExtendedMasterSecretModeName;
import nl.teslanet.mule.connectors.coap.api.config.security.KeyStore;
import nl.teslanet.mule.connectors.coap.api.config.security.PreSharedKeyParams;
import nl.teslanet.mule.connectors.coap.api.config.security.SignatureAlgorithm;
import nl.teslanet.mule.connectors.coap.api.config.security.TrustStore;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SecurityParams
implements VisitableConfig {
    @Parameter
    @Optional
    @Summary(value="The pre shared key configuration.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public PreSharedKeyParams preSharedKeyParams = null;
    @Parameter
    @Optional
    @Summary(value="The keystore configuration.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public KeyStore keyStore = null;
    @Parameter
    @Optional
    @Summary(value="The truststore configuration.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public TrustStore trustStore = null;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Truncate certificate path according the available trusted certificates before validation.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean truncateCertificatePathForValidation = true;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Use recommended cipher suites only.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean recommendedCipherSuitesOnly = true;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Use recommended ECC curves/groups only.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean recommendedCurvesOnly = true;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Use recommended signature- and hash-algorithms only.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public boolean recommendedSignatureAndHashAlgorithmsOnly = true;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List cipher suites that are preselected.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public List<CipherSuite> preselectedCipherSuites = null;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="Cipher suite(s) to use. Leave empty when preselection list is given.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public List<CipherSuite> cipherSuites = null;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of DTLS curves (supported groups).\nDefaults to all supported curves of the JCE at runtime.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public List<Curve> curves = null;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of supported signature and hash algorithms with hash algorithms.\nDefaults to SHA256 with ECDSA and SHA256 with RSA.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public List<SignatureAlgorithm> signatureAlgorithms = null;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of supported certificate key algorithms.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public List<CertificateKeyAlgorithm> certificateKeyAlgorithms = null;
    @Parameter
    @Optional(defaultValue="ENABLED")
    @Summary(value="The extended master secret mode to use.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public ExtendedMasterSecretModeName extendedMasterSecretMode = ExtendedMasterSecretModeName.ENABLED;
    @Parameter
    @Optional
    @Summary(value="Support use of Connection ID's. (rfc9146)")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    public ConnectionId supportConnectionId = null;

    @Override
    public void accept(ConfigVisitor visitor) throws ConfigException {
        visitor.visit(this);
        if (this.preSharedKeyParams != null) {
            this.preSharedKeyParams.accept(visitor);
        }
        if (this.keyStore != null) {
            this.keyStore.accept(visitor);
        }
        if (this.trustStore != null) {
            this.trustStore.accept(visitor);
        }
        if (this.supportConnectionId != null) {
            this.supportConnectionId.accept(visitor);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SecurityParams rhs = (SecurityParams)obj;
        return new EqualsBuilder().append((Object)this.preSharedKeyParams, (Object)rhs.preSharedKeyParams).append((Object)this.keyStore, (Object)rhs.keyStore).append((Object)this.trustStore, (Object)rhs.trustStore).append(this.truncateCertificatePathForValidation, rhs.truncateCertificatePathForValidation).append(this.recommendedCipherSuitesOnly, rhs.recommendedCipherSuitesOnly).append(this.recommendedCurvesOnly, rhs.recommendedCurvesOnly).append(this.recommendedSignatureAndHashAlgorithmsOnly, rhs.recommendedSignatureAndHashAlgorithmsOnly).append(this.preselectedCipherSuites, rhs.preselectedCipherSuites).append(this.cipherSuites, rhs.cipherSuites).append(this.curves, rhs.curves).append(this.signatureAlgorithms, rhs.signatureAlgorithms).append(this.certificateKeyAlgorithms, rhs.certificateKeyAlgorithms).append((Object)this.extendedMasterSecretMode, (Object)rhs.extendedMasterSecretMode).append((Object)this.supportConnectionId, (Object)rhs.supportConnectionId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 35).append((Object)this.preSharedKeyParams).append((Object)this.keyStore).append((Object)this.trustStore).append(this.truncateCertificatePathForValidation).append(this.recommendedCipherSuitesOnly).append(this.recommendedCurvesOnly).append(this.recommendedSignatureAndHashAlgorithmsOnly).append(this.preselectedCipherSuites).append(this.cipherSuites).append(this.curves).append(this.signatureAlgorithms).append(this.certificateKeyAlgorithms).append((Object)this.extendedMasterSecretMode).append((Object)this.supportConnectionId).toHashCode();
    }
}

