/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.api.options;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import nl.teslanet.mule.connectors.coap.api.Defs;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;

public class OptionUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final String EMPTY_STRING = "";
    private static final String LENGTH_ERROR_FORMAT = "Given value result in array length {%d}, which is not between {%d}..{%d} bytes.";

    private OptionUtils() {
    }

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) != 0;
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) != 0;
    }

    public static byte[] toBytes(int value) {
        int length;
        for (length = 0; length < 4 && (value < 0 || value >= 1 << length * 8); ++length) {
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[length - i - 1] = (byte)(value >> i * 8);
        }
        return result;
    }

    public static byte[] toBytes(int value, int minLength, int maxLength) throws OptionValueException {
        byte[] result = OptionUtils.toBytes(value);
        int length = result.length;
        if (length < minLength || length > maxLength) {
            throw new OptionValueException(String.format(LENGTH_ERROR_FORMAT, length, minLength, maxLength));
        }
        return result;
    }

    public static byte[] toBytes(long value) {
        int length;
        for (length = 0; length < 8 && (value < 0L || value >= 1L << length * 8); ++length) {
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[length - i - 1] = (byte)(value >> i * 8);
        }
        return result;
    }

    public static byte[] toBytes(long value, int minLength, int maxLength) throws OptionValueException {
        byte[] result = OptionUtils.toBytes(value);
        int length = result.length;
        if (length < minLength || length > maxLength) {
            throw new OptionValueException(String.format(LENGTH_ERROR_FORMAT, length, minLength, maxLength));
        }
        return result;
    }

    public static byte[] toBytes(String string) throws OptionValueException {
        return OptionUtils.toBytes(string, 0, Integer.MAX_VALUE);
    }

    public static byte[] toBytes(String string, int minLength, int maxLength) throws OptionValueException {
        byte[] bytes = EMPTY_BYTES;
        if (string == null || string.isEmpty()) {
            if (minLength > 0) {
                throw new OptionValueException("Given string is null or empty.");
            }
        } else {
            bytes = string.getBytes(Defs.COAP_CHARSET);
        }
        if (bytes.length < minLength || bytes.length > maxLength) {
            throw new OptionValueException(String.format(LENGTH_ERROR_FORMAT, bytes.length, minLength, maxLength));
        }
        return bytes;
    }

    public static byte[] toBytesFromHex(String hexString) throws OptionValueException {
        return OptionUtils.toBytesFromHex(hexString, 0, Integer.MAX_VALUE);
    }

    public static byte[] toBytesFromHex(String hexString, int minLength, int maxLength) throws OptionValueException {
        if (hexString == null || hexString.isEmpty()) {
            if (minLength > 0) {
                throw new OptionValueException("Given string is null or empty.");
            }
            return EMPTY_BYTES;
        }
        int length = hexString.length() / 2;
        if (length * 2 != hexString.length()) {
            throw new OptionValueException(String.format("Given hexString must have even number of characters. Actual number is {%d}.", hexString.length()));
        }
        if (length < minLength || length > maxLength) {
            throw new OptionValueException(String.format(LENGTH_ERROR_FORMAT, length, minLength, maxLength));
        }
        byte[] bytes = new byte[length];
        try {
            for (int i = 0; i < bytes.length; ++i) {
                int index = i * 2;
                int v = Integer.parseInt(hexString.substring(index, index + 2).toLowerCase(), 16);
                bytes[i] = (byte)v;
            }
        }
        catch (NumberFormatException e) {
            throw new OptionValueException("Cannot parse given value as hexadecimal.");
        }
        return bytes;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static InputStream toInputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return new ByteArrayInputStream(EMPTY_BYTES);
        }
        return new ByteArrayInputStream(bytes);
    }

    public static long toLong(byte[] bytes) {
        long result = 0L;
        if (bytes != null && bytes.length > 0) {
            if (bytes.length > 8) {
                throw new NumberFormatException("byte array size too large for long");
            }
            for (int i = 0; i < bytes.length; ++i) {
                result |= ((long)bytes[bytes.length - i - 1] & 0xFFL) << i * 8;
            }
        }
        return result;
    }

    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY_STRING;
        }
        return new String(bytes, Defs.COAP_CHARSET);
    }
}

