/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.attributes;

import java.net.URI;
import java.net.URISyntaxException;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapResponseAttributes;
import nl.teslanet.mule.connectors.coap.api.attributes.Result;
import nl.teslanet.mule.connectors.coap.api.options.RequestOptionsAttributes;
import nl.teslanet.mule.connectors.coap.api.options.ResponseOptionsAttributes;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributesStringBuilder;

public class CoapResponseAttributesImpl
extends CoapResponseAttributes {
    private URI requestUriObject = null;

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public synchronized void setRequestUriObject(URI uri) {
        this.requestUriObject = uri;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public void setRequestOptions(RequestOptionsAttributes requestOptionAttributes) {
        this.requestOptions = requestOptionAttributes;
    }

    public void setResponseOptions(ResponseOptionsAttributes responseOptions) {
        this.responseOptions = responseOptions;
    }

    @Override
    public String getRequestUri() {
        if (this.requestUri != null) {
            return this.requestUri;
        }
        return this.getOrCreateRequestUri().toASCIIString();
    }

    @Override
    public String getRequestScheme() {
        return this.getOrCreateRequestUri().getScheme();
    }

    @Override
    public String getRequestHost() {
        return this.getOrCreateRequestUri().getHost();
    }

    @Override
    public int getRequestPort() {
        return this.getOrCreateRequestUri().getPort();
    }

    @Override
    public String getRequestPath() {
        String path = this.getOrCreateRequestUri().getPath();
        if (path != null) {
            return path;
        }
        return "/";
    }

    @Override
    public String getRequestQuery() {
        String query = this.getOrCreateRequestUri().getQuery();
        if (query != null) {
            return query;
        }
        return "";
    }

    private synchronized URI getOrCreateRequestUri() {
        if (this.requestUriObject == null) {
            try {
                this.requestUriObject = new URI(this.requestUri == null ? "" : this.requestUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("cannot create URI from request uri", e);
            }
        }
        return this.requestUriObject;
    }

    public String toString() {
        AttributesStringBuilder builder = new AttributesStringBuilder(this);
        builder.append("localAddress", this.localAddress).append("remoteAddress", (Object)this.remoteAddress).append("requestType", (Object)this.requestType).append("requestCode", (Object)this.requestCode).append("requestOptions", (Object)this.requestOptions).append("requestUri", (Object)this.getRequestUri()).append("notification", this.notification).append("responseType", (Object)this.responseType).append("responseCode", (Object)this.responseCode).append("locationUri", (Object)this.locationUri).append("responseOptions", (Object)this.responseOptions).append("result", (Object)this.result.name());
        return builder.toString();
    }
}

