/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.Set;
import javax.crypto.SecretKey;
import nl.teslanet.mule.connectors.coap.api.config.ConfigException;
import nl.teslanet.mule.connectors.coap.api.config.security.KeyStore;
import nl.teslanet.mule.connectors.coap.api.config.security.PreSharedKey;
import nl.teslanet.mule.connectors.coap.api.config.security.PreSharedKeyGroup;
import nl.teslanet.mule.connectors.coap.api.config.security.PreSharedKeyStore;
import nl.teslanet.mule.connectors.coap.api.config.security.TrustStore;
import nl.teslanet.mule.connectors.coap.api.options.OptionValueException;
import nl.teslanet.mule.connectors.coap.internal.config.EndpointConfigVisitor;
import nl.teslanet.mule.connectors.coap.internal.exceptions.EndpointConstructionException;
import nl.teslanet.mule.connectors.coap.internal.utils.MuleInputStreamFactory;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedMultiPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.MultiPskFileStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;

public class DtlsEndpointConfigVisitor
extends EndpointConfigVisitor {
    private Set<PreSharedKey> preSharedKeys = null;
    private boolean keyStoreAvailable = false;
    private String keyStoreLocation = null;
    private String privateKeyAlias = null;
    private boolean trustStoreAvailable = false;
    private String trustedRootCertificateAlias = null;
    private String trustStoreLocation = null;
    private char[] keyStorePassword = null;
    private char[] privateKeyPassword = null;
    private char[] trustStorePassword = null;
    private boolean preSharedKeyFileAvailable = false;
    private String preSharedKeyStoreLocation = null;
    private String preSharedKeyStorePassword = null;

    @Override
    public void visit(PreSharedKeyGroup toVisit) throws ConfigException {
        super.visit(toVisit);
        this.preSharedKeys = toVisit.preSharedKeys;
    }

    @Override
    public void visit(PreSharedKeyStore toVisit) throws ConfigException {
        super.visit(toVisit);
        this.preSharedKeyFileAvailable = true;
        this.preSharedKeyStoreLocation = toVisit.path;
        if (toVisit.password != null) {
            this.preSharedKeyStorePassword = toVisit.password;
        }
    }

    @Override
    public void visit(KeyStore toVisit) throws ConfigException {
        super.visit(toVisit);
        this.keyStoreAvailable = true;
        this.keyStoreLocation = toVisit.path;
        this.privateKeyAlias = toVisit.privateKeyAlias;
        if (toVisit.password != null) {
            this.keyStorePassword = toVisit.password.toCharArray();
        }
        if (toVisit.privateKeyPassword != null) {
            this.privateKeyPassword = toVisit.privateKeyPassword.toCharArray();
        }
    }

    @Override
    public void visit(TrustStore toVisit) throws ConfigException {
        super.visit(toVisit);
        this.trustStoreAvailable = true;
        this.trustStoreLocation = toVisit.path;
        this.trustedRootCertificateAlias = toVisit.rootCertificateAlias;
        if (toVisit.password != null) {
            this.trustStorePassword = toVisit.password.toCharArray();
        }
    }

    @Override
    public CoapEndpoint getEndpoint() throws EndpointConstructionException {
        MuleInputStreamFactory streamFactory = new MuleInputStreamFactory();
        DtlsConnectorConfig.Builder connectBuilder = new DtlsConnectorConfig.Builder(this.getConfiguration());
        connectBuilder.setAddress(this.getLocalAddress());
        connectBuilder.setReuseAddress(this.isReuseAddress());
        if (this.preSharedKeys != null) {
            AdvancedMultiPskStore pskStore = new AdvancedMultiPskStore();
            try {
                for (PreSharedKey key : this.preSharedKeys) {
                    InetSocketAddress address;
                    if (key.getHost() == null) {
                        pskStore.setKey(key.getIdentity(), key.getKey().getByteArray());
                        continue;
                    }
                    if (key.getVirtualHost() != null) {
                        address = new InetSocketAddress(key.getHost(), (int)key.getPort());
                        pskStore.addKnownPeer(address, key.getVirtualHost(), key.getIdentity(), key.getKey().getByteArray());
                        continue;
                    }
                    address = new InetSocketAddress(key.getHost(), (int)key.getPort());
                    pskStore.addKnownPeer(address, key.getIdentity(), key.getKey().getByteArray());
                }
            }
            catch (OptionValueException e) {
                throw new EndpointConstructionException(String.format("DTLS Endpoint { %s } preshared key host error.", this.getEndpointName()), e);
            }
            connectBuilder.setAdvancedPskStore((AdvancedPskStore)pskStore);
        } else if (this.preSharedKeyFileAvailable) {
            InputStream pskStream;
            MultiPskFileStore pskFile = new MultiPskFileStore();
            try {
                pskStream = streamFactory.create(streamFactory.getScheme() + this.preSharedKeyStoreLocation);
            }
            catch (IOException e) {
                throw new EndpointConstructionException(String.format("DTLS Endpoint { %s } preshared key file { %s } error.", this.getEndpointName(), this.preSharedKeyStoreLocation), e);
            }
            if (this.preSharedKeyStorePassword != null) {
                SecretKey secretKey = SecretUtil.create((byte[])this.preSharedKeyStorePassword.getBytes(), (String)"PASSWORD");
                pskFile.loadPskCredentials(pskStream, secretKey);
            } else {
                pskFile.loadPskCredentials(pskStream);
            }
            connectBuilder.setAdvancedPskStore((AdvancedPskStore)pskFile);
        }
        SslContextUtil.configure((String)streamFactory.getScheme(), (SslContextUtil.InputStreamFactory)streamFactory);
        if (this.keyStoreAvailable) {
            try {
                SslContextUtil.Credentials serverCredentials = SslContextUtil.loadCredentials((String)(streamFactory.getScheme() + this.keyStoreLocation), (String)this.privateKeyAlias, (char[])this.keyStorePassword, (char[])this.privateKeyPassword);
                SingleCertificateProvider identityProvider = new SingleCertificateProvider(serverCredentials.getPrivateKey(), serverCredentials.getPublicKey());
                connectBuilder.setCertificateIdentityProvider((CertificateProvider)identityProvider);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new EndpointConstructionException(String.format("DTLS Endpoint { %s } keystore error.", this.getEndpointName()), e);
            }
        }
        if (this.trustStoreAvailable) {
            try {
                Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)(streamFactory.getScheme() + this.trustStoreLocation), (String)this.trustedRootCertificateAlias, (char[])this.trustStorePassword);
                StaticNewAdvancedCertificateVerifier.Builder verifierBuilder = StaticNewAdvancedCertificateVerifier.builder();
                verifierBuilder.setTrustAllRPKs();
                verifierBuilder.setTrustedCertificates(trustedCertificates);
                connectBuilder.setAdvancedCertificateVerifier(verifierBuilder.build());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new EndpointConstructionException(String.format("DTLS Endpoint { %s } truststore error.", this.getEndpointName()), e);
            }
        }
        DTLSConnector dtlsConnector = new DTLSConnector(connectBuilder.build());
        CoapEndpoint.Builder endpointBuilder = new CoapEndpoint.Builder();
        endpointBuilder.setConfiguration(this.getConfiguration());
        endpointBuilder.setConnector((Connector)dtlsConnector);
        return endpointBuilder.build();
    }
}

