/*
 * Decompiled with CFR 0.152.
 */
package nl.teslanet.mule.connectors.coap.internal.server;

import java.io.InputStream;
import javax.inject.Inject;
import nl.teslanet.mule.connectors.coap.api.CoapResponseCode;
import nl.teslanet.mule.connectors.coap.api.ResponseParams;
import nl.teslanet.mule.connectors.coap.api.attributes.CoapRequestAttributes;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalExchangeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidByteArrayValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidOptionValueException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalInvalidResponseCodeException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalResourceUriException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUnkownOptionException;
import nl.teslanet.mule.connectors.coap.internal.exceptions.InternalUriPatternException;
import nl.teslanet.mule.connectors.coap.internal.options.MediaTypeMediator;
import nl.teslanet.mule.connectors.coap.internal.server.OperationalListener;
import nl.teslanet.mule.connectors.coap.internal.server.RequestCodeFlags;
import nl.teslanet.mule.connectors.coap.internal.server.Server;
import nl.teslanet.mule.connectors.coap.internal.utils.AttributeUtils;
import nl.teslanet.mule.connectors.coap.internal.utils.MessageUtils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="listener")
@EmitsResponse
@MediaType(value="application/octet-stream", strict=false)
public class Listener
extends Source<InputStream, CoapRequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Listener.class);
    @Config
    private Server server;
    @Inject
    private TransformationService transformationService;
    @Parameter
    @Optional(defaultValue="/*")
    @Summary(value="The pathPattern defines the resources the listener listens on.")
    private String pathPattern;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Get requests")
    @Summary(value="The listener will receive GET requests.")
    private boolean get;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Post requests")
    @Summary(value="The listener will receive POST requests.")
    private boolean post;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Put requests")
    @Summary(value="The listener will receive PUT requests.")
    private boolean put;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Delete requests")
    @Summary(value="The listener will receive DELETE requests.")
    private boolean delete;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Fetch requests")
    @Summary(value="The listener will receive FETCH requests.")
    private boolean fetch;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept Patch requests")
    @Summary(value="The listener will receive PATCH requests.")
    private boolean patch;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Accept iPatch requests")
    @Summary(value="The listener will receive iPatch requests.")
    private boolean ipatch;
    OperationalListener operationalListener = null;

    public void onStart(SourceCallback<InputStream, CoapRequestAttributes> sourceCallback) throws MuleException {
        try {
            this.operationalListener = new OperationalListener(this.pathPattern, new RequestCodeFlags(this.get, this.post, this.put, this.delete, this.fetch, this.patch, this.ipatch), sourceCallback);
            this.server.addListener(this.operationalListener);
        }
        catch (InternalResourceUriException | InternalUriPatternException e) {
            throw new DefaultMuleException((Object)((Object)this) + " start failed.", (Throwable)e);
        }
        LOGGER.info("{} started.", (Object)this);
    }

    @OnSuccess
    @MediaType(value="*/*", strict=false)
    public void onSuccess(@Optional @NullSafe @Alias(value="response") @Placement(tab="Response", order=1) ResponseParams response, SourceCallbackContext callbackContext) throws InternalInvalidByteArrayValueException, InternalInvalidResponseCodeException, InternalInvalidOptionValueException, InternalExchangeException, InternalUnkownOptionException {
        CoapResponseCode defaultCoapResponseCode = (CoapResponseCode)((Object)callbackContext.getVariable("defaultResponseCode").orElseThrow(() -> new InternalInvalidResponseCodeException("Internal error: no defaultCoAPResponseCode provided")));
        Response coapResponse = new Response(AttributeUtils.toResponseCode(response.getResponseCode(), defaultCoapResponseCode));
        TypedValue<Object> responsePayload = response.getResponsePayload();
        coapResponse.getOptions().setContentFormat(MediaTypeMediator.toContentFormat(responsePayload.getDataType().getMediaType()));
        MessageUtils.copyOptions(response.getResponseOptionsParams(), coapResponse.getOptions(), this.transformationService);
        MessageUtils.copyOptions(response.getResponseOptionsParams().getOtherOptions(), coapResponse.getOptions(), this.transformationService);
        try {
            coapResponse.setPayload(MessageUtils.toBytes(responsePayload, this.transformationService));
        }
        catch (Exception e) {
            throw new InternalInvalidByteArrayValueException("Cannot convert payload to byte[]", e);
        }
        ((CoapExchange)callbackContext.getVariable("coapExchange").orElseThrow(() -> new InternalExchangeException("Not able to issue CoAP response: no exchange object provided."))).respond(coapResponse);
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) throws InternalExchangeException {
        if (!sourceResult.isSuccess()) {
            CoapExchange exchange = (CoapExchange)sourceResult.getSourceCallbackContext().getVariable("coapExchange").orElseThrow(() -> new InternalExchangeException("Not able to issue CoAP internal server error response: no exchange object provided."));
            if (sourceResult.getInvocationError().isPresent()) {
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "EXCEPTION IN PROCESSING REQUEST");
            } else if (sourceResult.getResponseError().isPresent()) {
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "EXCEPTION IN PROCESSING FLOW");
            } else {
                exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "INTERNAL SERVER ERROR");
            }
        }
    }

    public void onStop() {
        this.server.removeListener(this.operationalListener);
        this.operationalListener = null;
        LOGGER.info("{} stopped.", (Object)this);
    }

    public String toString() {
        return "CoAP Listener { " + this.server.getServerName() + "::" + this.pathPattern + " }";
    }
}

